/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.seasar.extension.dxo.util.Expression;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class SimpleExpression
implements Expression {
    protected LinkedList conversionRuleList = new LinkedList();

    public Map evaluate(Object source) {
        LinkedHashMap map = new LinkedHashMap();
        Iterator it = this.conversionRuleList.iterator();
        while (it.hasNext()) {
            ConversionRule conversionRule = (ConversionRule)it.next();
            conversionRule.evaluate(source, map);
        }
        return map;
    }

    protected void addDestProperty(String destProperty) {
        this.conversionRuleList.add(new ConversionRule(destProperty));
    }

    protected void addSourceProperty(String sourceProperty) {
        ConversionRule pair = (ConversionRule)this.conversionRuleList.getLast();
        pair.addSourceProperty(sourceProperty);
    }

    public static class ConversionRule {
        protected String destProperty;
        protected LinkedList sourcePropertyList = new LinkedList();

        public ConversionRule(String destProperty) {
            this.destProperty = destProperty;
        }

        public void addSourceProperty(String sourceProperty) {
            this.sourcePropertyList.addLast(sourceProperty);
        }

        public void evaluate(Object source, Map dest) {
            Iterator it = this.sourcePropertyList.iterator();
            while (it.hasNext()) {
                String sourceProperty = (String)it.next();
                if (sourceProperty == null) {
                    source = null;
                } else if (source instanceof Map) {
                    source = ((Map)source).get(sourceProperty);
                } else {
                    BeanDesc beanDesc = BeanDescFactory.getBeanDesc(source.getClass());
                    PropertyDesc propertyDesc = beanDesc.getPropertyDesc(sourceProperty);
                    source = propertyDesc.getValue(source);
                }
                if (source != null) continue;
                break;
            }
            dest.put(this.destProperty, source);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.destProperty).append(" : ");
            boolean hasValue = false;
            Iterator it = this.sourcePropertyList.iterator();
            while (it.hasNext()) {
                buf.append(it.next()).append(", ");
                hasValue = true;
            }
            if (hasValue) {
                buf.setLength(buf.length() - 2);
            }
            return new String(buf);
        }
    }
}

