/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.gosen.GosenPartOfSpeechKeepFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class GosenPartOfSpeechKeepFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private boolean enablePositionIncrements;
    private Set<String> keepTags;

    public void inform(ResourceLoader loader) {
        String keepTagFiles = (String)this.args.get("tags");
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        try {
            CharArraySet cas = this.getWordSet(loader, keepTagFiles, false);
            this.keepTags = new HashSet<String>();
            for (Object element : cas) {
                char[] chars = (char[])element;
                this.keepTags.add(new String(chars));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TokenStream create(TokenStream stream) {
        return new GosenPartOfSpeechKeepFilter(this.enablePositionIncrements, stream, this.keepTags);
    }
}

