/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.dbmeta.info;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.Entity;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.dbmeta.info.RelationInfo;
import org.seasar.robot.dbflute.util.DfReflectionUtil;
import org.seasar.robot.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignInfo
implements RelationInfo {
    protected final String _foreignPropertyName;
    protected final DBMeta _localDBMeta;
    protected final DBMeta _foreignDBMeta;
    protected final Map<ColumnInfo, ColumnInfo> _localForeignColumnInfoMap;
    protected final Map<ColumnInfo, ColumnInfo> _foreignLocalColumnInfoMap;
    protected final int _relationNo;
    protected final boolean _oneToOne;
    protected final boolean _bizOneToOne;

    public ForeignInfo(String foreignPropertyName, DBMeta localDBMeta, DBMeta foreignDBMeta, Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap, int relationNo, boolean oneToOne, boolean bizOneToOne) {
        this.assertObjectNotNull("foreignPropertyName", foreignPropertyName);
        this.assertObjectNotNull("localDBMeta", localDBMeta);
        this.assertObjectNotNull("foreignDBMeta", foreignDBMeta);
        this.assertObjectNotNull("localForeignColumnInfoMap", localForeignColumnInfoMap);
        this._foreignPropertyName = foreignPropertyName;
        this._localDBMeta = localDBMeta;
        this._foreignDBMeta = foreignDBMeta;
        this._localForeignColumnInfoMap = localForeignColumnInfoMap;
        Set<ColumnInfo> keySet = localForeignColumnInfoMap.keySet();
        this._foreignLocalColumnInfoMap = new LinkedHashMap<ColumnInfo, ColumnInfo>();
        for (ColumnInfo key : keySet) {
            ColumnInfo value = localForeignColumnInfoMap.get(key);
            this._foreignLocalColumnInfoMap.put(value, key);
        }
        this._relationNo = relationNo;
        this._oneToOne = oneToOne;
        this._bizOneToOne = bizOneToOne;
    }

    public ColumnInfo findLocalByForeign(String foreignColumnDbName) {
        ColumnInfo keyColumnInfo = this._foreignDBMeta.findColumnInfo(foreignColumnDbName);
        ColumnInfo resultColumnInfo = this._foreignLocalColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by foreignColumnDbName in foreignLocalColumnInfoMap:";
            msg = msg + " foreignColumnDbName=" + foreignColumnDbName + " foreignLocalColumnInfoMap=" + this._foreignLocalColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public <PROPERTY extends Entity> PROPERTY read(Entity localEntity) {
        return (PROPERTY)((Entity)this.invokeMethod(this.reader(), localEntity, new Object[0]));
    }

    public Method reader() {
        Class<? extends Entity> localType = this._localDBMeta.getEntityType();
        String methodName = this.buildAccessorName("get");
        Method method = this.findMethod(localType, this.buildAccessorName("get"), new Class[0]);
        if (method == null) {
            String msg = "Failed to find the method by the name:";
            msg = msg + " methodName=" + methodName;
            throw new IllegalStateException(msg);
        }
        return method;
    }

    public void write(Entity localEntity, Entity foreignEntity) {
        this.invokeMethod(this.writer(), localEntity, new Object[]{foreignEntity});
    }

    public Method writer() {
        Class<? extends Entity> localType = this._localDBMeta.getEntityType();
        Class<? extends Entity> foreignType = this._foreignDBMeta.getEntityType();
        String methodName = this.buildAccessorName("set");
        Method method = this.findMethod(localType, methodName, new Class[]{foreignType});
        if (method == null) {
            String msg = "Failed to find the method by the name:";
            msg = msg + " methodName=" + methodName;
            msg = msg + " foreignType=" + foreignType;
            throw new IllegalStateException(msg);
        }
        return method;
    }

    protected String buildAccessorName(String prefix) {
        return prefix + this.initCap(this._foreignPropertyName);
    }

    @Override
    public String getRelationPropertyName() {
        return this.getForeignPropertyName();
    }

    @Override
    public DBMeta getTargetDBMeta() {
        return this.getForeignDBMeta();
    }

    @Override
    public Map<ColumnInfo, ColumnInfo> getLocalTargetColumnInfoMap() {
        return this.getLocalForeignColumnInfoMap();
    }

    @Override
    public boolean isReferrer() {
        return false;
    }

    protected String initCap(String name) {
        return Srl.initCap(name);
    }

    protected Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        return DfReflectionUtil.getAccessibleMethod(clazz, methodName, argTypes);
    }

    protected Object invokeMethod(Method method, Object target, Object[] args) {
        return DfReflectionUtil.invoke(method, target, args);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this._foreignPropertyName.hashCode() + this._localDBMeta.hashCode() + this._foreignDBMeta.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ForeignInfo)) {
            return false;
        }
        ForeignInfo target = (ForeignInfo)obj;
        if (!this._foreignPropertyName.equals(target.getForeignPropertyName())) {
            return false;
        }
        if (!this._localDBMeta.equals(target.getLocalDBMeta())) {
            return false;
        }
        return this._foreignDBMeta.equals(target.getForeignDBMeta());
    }

    public String toString() {
        return this._localDBMeta.getTableDbName() + "." + this._foreignPropertyName + "->" + this._foreignDBMeta.getTableDbName();
    }

    public String getForeignPropertyName() {
        return this._foreignPropertyName;
    }

    @Override
    public DBMeta getLocalDBMeta() {
        return this._localDBMeta;
    }

    public DBMeta getForeignDBMeta() {
        return this._foreignDBMeta;
    }

    public Map<ColumnInfo, ColumnInfo> getLocalForeignColumnInfoMap() {
        return Collections.unmodifiableMap(this._localForeignColumnInfoMap);
    }

    public Map<ColumnInfo, ColumnInfo> getForeignLocalColumnInfoMap() {
        return Collections.unmodifiableMap(this._foreignLocalColumnInfoMap);
    }

    public int getRelationNo() {
        return this._relationNo;
    }

    @Override
    public boolean isOneToOne() {
        return this._oneToOne;
    }

    public boolean isBizOneToOne() {
        return this._bizOneToOne;
    }
}

