/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean;

import org.seasar.robot.dbflute.cbean.ListResultBean;
import org.seasar.robot.dbflute.cbean.mapping.EntityDtoMapper;
import org.seasar.robot.dbflute.cbean.pagenavi.group.PageGroupBean;
import org.seasar.robot.dbflute.cbean.pagenavi.group.PageGroupOption;
import org.seasar.robot.dbflute.cbean.pagenavi.range.PageRangeBean;
import org.seasar.robot.dbflute.cbean.pagenavi.range.PageRangeOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingResultBean<ENTITY>
extends ListResultBean<ENTITY> {
    private static final long serialVersionUID = 1L;
    protected int _pageSize;
    protected int _currentPageNumber;
    protected PageGroupBean _pageGroupBean;
    protected PageGroupOption _pageGroupOption;
    protected PageRangeBean _pageRangeBean;
    protected PageRangeOption _pageRangeOption;

    public boolean isExistPrePage() {
        return this._allRecordCount > 0 && this._currentPageNumber > 1;
    }

    public boolean isExistNextPage() {
        return this._allRecordCount > 0 && this._currentPageNumber < this.getAllPageCount();
    }

    protected void initializeCachedBeans() {
        this.initializePageGroup();
        this.initializePageRange();
    }

    protected void initializePageGroup() {
        this._pageGroupBean = null;
    }

    public int getPageGroupSize() {
        return this._pageGroupOption != null ? this._pageGroupOption.getPageGroupSize() : 0;
    }

    public void setPageGroupSize(int pageGroupSize) {
        PageGroupOption option = new PageGroupOption();
        option.setPageGroupSize(pageGroupSize);
        this.setPageGroupOption(option);
    }

    public void setPageGroupOption(PageGroupOption pageGroupOption) {
        this.initializePageGroup();
        this._pageGroupOption = pageGroupOption;
    }

    public PageGroupBean pageGroup() {
        this.assertPageGroupValid();
        if (this._pageGroupBean == null) {
            this._pageGroupBean = new PageGroupBean();
            this._pageGroupBean.setPageGroupOption(this._pageGroupOption);
            this._pageGroupBean.setCurrentPageNumber(this.getCurrentPageNumber());
            this._pageGroupBean.setAllPageCount(this.getAllPageCount());
        }
        return this._pageGroupBean;
    }

    protected void assertPageGroupValid() {
        if (this._pageGroupOption == null) {
            String msg = "The pageGroupOption should not be null. Please call setPageGroupOption().";
            throw new IllegalStateException(msg);
        }
        if (this._pageGroupOption.getPageGroupSize() == 0) {
            String msg = "The pageGroupSize should be greater than 1. But the value is zero.";
            msg = msg + " pageGroupSize=" + this._pageGroupOption.getPageGroupSize();
            throw new IllegalStateException(msg);
        }
        if (this._pageGroupOption.getPageGroupSize() == 1) {
            String msg = "The pageGroupSize should be greater than 1. But the value is one.";
            msg = msg + " pageGroupSize=" + this._pageGroupOption.getPageGroupSize();
            throw new IllegalStateException(msg);
        }
    }

    protected void initializePageRange() {
        this._pageRangeBean = null;
    }

    public int getPageRangeSize() {
        return this._pageRangeOption != null ? this._pageRangeOption.getPageRangeSize() : 0;
    }

    public void setPageRangeSize(int pageRangeSize) {
        PageRangeOption option = new PageRangeOption();
        option.setPageRangeSize(pageRangeSize);
        this.setPageRangeOption(option);
    }

    public void setPageRangeOption(PageRangeOption pageRangeOption) {
        this.initializePageRange();
        this._pageRangeOption = pageRangeOption;
    }

    public PageRangeBean pageRange() {
        this.assertPageRangeValid();
        if (this._pageRangeBean == null) {
            this._pageRangeBean = new PageRangeBean();
            this._pageRangeBean.setPageRangeOption(this._pageRangeOption);
            this._pageRangeBean.setCurrentPageNumber(this.getCurrentPageNumber());
            this._pageRangeBean.setAllPageCount(this.getAllPageCount());
        }
        return this._pageRangeBean;
    }

    protected void assertPageRangeValid() {
        if (this._pageRangeOption == null) {
            String msg = "The pageRangeOption should not be null. Please call setPageRangeOption().";
            throw new IllegalStateException(msg);
        }
        int pageRangeSize = this._pageRangeOption.getPageRangeSize();
        if (pageRangeSize == 0) {
            String msg = "The pageRangeSize should be greater than 1. But the value is zero.";
            throw new IllegalStateException(msg);
        }
    }

    protected int calculateAllPageCount(int allRecordCount, int pageSize) {
        if (allRecordCount == 0) {
            return 1;
        }
        int pageCountBase = allRecordCount / pageSize;
        if (allRecordCount % pageSize > 0) {
            ++pageCountBase;
        }
        return pageCountBase;
    }

    protected int calculateCurrentStartRecordNumber(int currentPageNumber, int pageSize) {
        return (currentPageNumber - 1) * pageSize + 1;
    }

    protected int calculateCurrentEndRecordNumber(int currentPageNumber, int pageSize) {
        return this.calculateCurrentStartRecordNumber(currentPageNumber, pageSize) + this._selectedList.size() - 1;
    }

    @Override
    public <DTO> PagingResultBean<DTO> mappingList(EntityDtoMapper<ENTITY, DTO> entityDtoMapper) {
        ListResultBean<DTO> ls = super.mappingList(entityDtoMapper);
        PagingResultBean<DTO> mappingList = new PagingResultBean<DTO>();
        mappingList.setSelectedList(ls.getSelectedList());
        mappingList.setTableDbName(this.getTableDbName());
        mappingList.setAllRecordCount(this.getAllRecordCount());
        mappingList.setOrderByClause(this.getOrderByClause());
        mappingList.setPageSize(this.getPageSize());
        mappingList.setCurrentPageNumber(this.getCurrentPageNumber());
        mappingList.setPageRangeOption(this._pageRangeOption);
        mappingList.setPageGroupOption(this._pageGroupOption);
        return mappingList;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + this._pageSize;
        result = 31 * result + this._currentPageNumber;
        if (this._selectedList != null) {
            result = 31 * result + ((Object)this._selectedList).hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        boolean equals = super.equals(other);
        if (!equals) {
            return false;
        }
        if (!(other instanceof PagingResultBean)) {
            return false;
        }
        PagingResultBean otherBean = (PagingResultBean)other;
        if (this._pageSize != otherBean.getPageSize()) {
            return false;
        }
        return this._currentPageNumber == otherBean.getCurrentPageNumber();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this.getCurrentPageNumber()).append("/").append(this.getAllPageCount());
        sb.append(" of ").append(this.getAllRecordCount());
        sb.append(" ").append(this.isExistPrePage()).append("/").append(this.isExistNextPage());
        if (this._pageGroupOption != null) {
            sb.append(" group:{").append(this.getPageGroupSize()).append(",").append(this.pageGroup().createPageNumberList()).append("}");
        }
        if (this._pageRangeOption != null) {
            sb.append(" range:{").append(this.getPageRangeSize()).append(",").append(this._pageRangeOption.isFillLimit());
            sb.append(",").append(this.pageRange().createPageNumberList()).append("}");
        }
        sb.append(" list=").append(this.getSelectedList() != null ? Integer.valueOf(this.getSelectedList().size()) : null);
        sb.append(" page=").append(this.getPageSize());
        sb.append("}");
        sb.append(":selectedList=").append(this.getSelectedList());
        return sb.toString();
    }

    @Override
    public int getAllRecordCount() {
        return super.getAllRecordCount();
    }

    @Override
    public void setAllRecordCount(int allRecordCount) {
        this.initializeCachedBeans();
        super.setAllRecordCount(allRecordCount);
    }

    public int getPageSize() {
        return this._pageSize;
    }

    public void setPageSize(int pageSize) {
        this.initializeCachedBeans();
        this._pageSize = pageSize;
    }

    public int getCurrentPageNumber() {
        return this._currentPageNumber;
    }

    public void setCurrentPageNumber(int currentPageNumber) {
        this.initializeCachedBeans();
        this._currentPageNumber = currentPageNumber;
    }

    public int getAllPageCount() {
        return this.calculateAllPageCount(this._allRecordCount, this._pageSize);
    }

    public int getPrePageNumber() {
        if (!this.isExistPrePage()) {
            String msg = "The previous page should exist when you use prePageNumber:";
            msg = msg + " currentPageNumber=" + this._currentPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._currentPageNumber - 1;
    }

    public int getNextPageNumber() {
        if (!this.isExistNextPage()) {
            String msg = "The next page should exist when you use nextPageNumber:";
            msg = msg + " currentPageNumber=" + this._currentPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._currentPageNumber + 1;
    }

    public int getCurrentStartRecordNumber() {
        return this.calculateCurrentStartRecordNumber(this._currentPageNumber, this._pageSize);
    }

    public int getCurrentEndRecordNumber() {
        return this.calculateCurrentEndRecordNumber(this._currentPageNumber, this._pageSize);
    }
}

