/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv.outsidesql;

import java.util.List;
import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.robot.dbflute.bhv.outsidesql.OutsideSqlBasicExecutor;
import org.seasar.robot.dbflute.bhv.outsidesql.factory.OutsideSqlExecutorFactory;
import org.seasar.robot.dbflute.exception.DangerousResultSizeException;
import org.seasar.robot.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.seasar.robot.dbflute.jdbc.FetchBean;
import org.seasar.robot.dbflute.jdbc.StatementConfig;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.robot.dbflute.util.DfSystemUtil;
import org.seasar.robot.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlEntityExecutor<PARAMETER_BEAN> {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final String _tableDbName;
    protected DBDef _currentDBDef;
    protected final StatementConfig _defaultStatementConfig;
    protected final OutsideSqlOption _outsideSqlOption;
    protected final OutsideSqlExecutorFactory _outsideSqlExecutorFactory;

    public OutsideSqlEntityExecutor(BehaviorCommandInvoker behaviorCommandInvoker, String tableDbName, DBDef currentDBDef, StatementConfig defaultStatementConfig, OutsideSqlOption outsideSqlOption, OutsideSqlExecutorFactory outsideSqlExecutorFactory) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
        this._defaultStatementConfig = defaultStatementConfig;
        this._outsideSqlOption = outsideSqlOption;
        this._outsideSqlExecutorFactory = outsideSqlExecutorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ENTITY> ENTITY selectEntity(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        List<ENTITY> ls;
        int preSafetyMaxResultSize = this.xcheckSafetyResultAsOneIfNeed(pmb);
        try {
            ls = this.doSelectList(path, pmb, entityType);
        }
        catch (DangerousResultSizeException e) {
            String searchKey4Log = this.buildSearchKey4Exception(path, pmb, entityType);
            this.throwSelectEntityDuplicatedException("{over safetyMaxResultSize '1'}", searchKey4Log, e);
            ENTITY ENTITY = null;
            return ENTITY;
        }
        finally {
            this.xrestoreSafetyResultIfNeed(pmb, preSafetyMaxResultSize);
        }
        if (ls == null || ls.isEmpty()) {
            return null;
        }
        if (ls.size() > 1) {
            String searchKey4Log = this.buildSearchKey4Exception(path, pmb, entityType);
            this.throwSelectEntityDuplicatedException(String.valueOf(ls.size()), searchKey4Log, null);
        }
        return ls.get(0);
    }

    protected <ENTITY> List<ENTITY> doSelectList(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        return this.createBasicExecutor().selectList(path, pmb, entityType);
    }

    protected OutsideSqlBasicExecutor createBasicExecutor() {
        return this._outsideSqlExecutorFactory.createBasic(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, this._outsideSqlOption);
    }

    public <ENTITY> ENTITY selectEntityWithDeletedCheck(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        ENTITY entity = this.selectEntity(path, pmb, entityType);
        if (entity == null) {
            this.throwSelectEntityAlreadyDeletedException(this.buildSearchKey4Exception(path, pmb, entityType));
        }
        return entity;
    }

    protected <ENTITY> String buildSearchKey4Exception(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        String tmp = "table  = " + this._outsideSqlOption.getTableDbName() + OutsideSqlEntityExecutor.ln();
        tmp = tmp + "path   = " + path + OutsideSqlEntityExecutor.ln();
        tmp = tmp + "pmbean = " + DfTypeUtil.toClassTitle(pmb) + ":" + pmb + OutsideSqlEntityExecutor.ln();
        tmp = tmp + "entity = " + DfTypeUtil.toClassTitle(entityType) + OutsideSqlEntityExecutor.ln();
        tmp = tmp + "option = " + this._outsideSqlOption;
        return tmp;
    }

    protected int xcheckSafetyResultAsOneIfNeed(PARAMETER_BEAN pmb) {
        if (pmb instanceof FetchBean) {
            int safetyMaxResultSize = ((FetchBean)pmb).getSafetyMaxResultSize();
            ((FetchBean)pmb).checkSafetyResult(1);
            return safetyMaxResultSize;
        }
        return 0;
    }

    protected void xrestoreSafetyResultIfNeed(PARAMETER_BEAN pmb, int preSafetyMaxResultSize) {
        if (pmb instanceof FetchBean) {
            ((FetchBean)pmb).checkSafetyResult(preSafetyMaxResultSize);
        }
    }

    protected void throwSelectEntityAlreadyDeletedException(Object searchKey) {
        this.createBhvExThrower().throwSelectEntityAlreadyDeletedException(searchKey);
    }

    protected void throwSelectEntityDuplicatedException(String resultCountExp, Object searchKey, Throwable cause) {
        this.createBhvExThrower().throwSelectEntityDuplicatedException(resultCountExp, searchKey, cause);
    }

    public OutsideSqlEntityExecutor<PARAMETER_BEAN> removeBlockComment() {
        this._outsideSqlOption.removeBlockComment();
        return this;
    }

    public OutsideSqlEntityExecutor<PARAMETER_BEAN> removeLineComment() {
        this._outsideSqlOption.removeLineComment();
        return this;
    }

    public OutsideSqlEntityExecutor<PARAMETER_BEAN> formatSql() {
        this._outsideSqlOption.formatSql();
        return this;
    }

    public OutsideSqlEntityExecutor<PARAMETER_BEAN> configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        return this._behaviorCommandInvoker.createBehaviorExceptionThrower();
    }

    protected static String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

