/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv.core.execution;

import java.util.Map;
import javax.sql.DataSource;
import org.seasar.robot.dbflute.bhv.core.execution.AbstractFixedSqlExecution;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlFilter;
import org.seasar.robot.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutsideSqlExecution
extends AbstractFixedSqlExecution {
    protected boolean _removeBlockComment;
    protected boolean _removeLineComment;
    protected boolean _formatSql;
    protected OutsideSqlFilter _outsideSqlFilter;

    public AbstractOutsideSqlExecution(DataSource dataSource, StatementFactory statementFactory, Map<String, Class<?>> argNameTypeMap, String twoWaySql) {
        super(dataSource, statementFactory, argNameTypeMap, twoWaySql);
    }

    @Override
    protected String filterExecutedSql(String sql) {
        if (this._outsideSqlFilter != null) {
            sql = this._outsideSqlFilter.filterExecution(sql, this.getOutsideSqlExecutionFilterType());
        }
        if (this._removeBlockComment) {
            sql = Srl.removeBlockComment(sql);
        }
        if (this._removeLineComment) {
            sql = Srl.removeLineComment(sql);
        }
        if (this._formatSql) {
            sql = Srl.removeEmptyLine(sql);
        }
        return sql;
    }

    protected abstract OutsideSqlFilter.ExecutionFilterType getOutsideSqlExecutionFilterType();

    public boolean isRemoveBlockComment() {
        return this._removeBlockComment;
    }

    public void setRemoveBlockComment(boolean removeBlockComment) {
        this._removeBlockComment = removeBlockComment;
    }

    public boolean isRemoveLineComment() {
        return this._removeLineComment;
    }

    public void setRemoveLineComment(boolean removeLineComment) {
        this._removeLineComment = removeLineComment;
    }

    public boolean isRemoveEmptyLine() {
        return this._formatSql;
    }

    public void setFormatSql(boolean formatSql) {
        this._formatSql = formatSql;
    }

    public OutsideSqlFilter getOutsideSqlFilter() {
        return this._outsideSqlFilter;
    }

    public void setOutsideSqlFilter(OutsideSqlFilter outsideSqlFilter) {
        this._outsideSqlFilter = outsideSqlFilter;
    }
}

