/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jp.gr.java_conf.dangan.io.LittleEndian;
import jp.gr.java_conf.dangan.util.MsdosDate;
import jp.gr.java_conf.dangan.util.lha.CRC16;
import jp.gr.java_conf.dangan.util.lha.LhaChecksum;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class LhaHeader
implements Cloneable {
    public static final int UNKNOWN = -1;
    public static final int NO_CRC = -2;
    private long OriginalSize = -1L;
    private Date LastModified = null;
    private String Path = "";
    private int CRC = -1;
    private String Method = "-lh5-";
    private long CompressedSize = -1L;
    private int HeaderLevel = 2;
    private byte OSID = (byte)74;
    private byte[] ExtraData = null;
    private byte Level0DosAttribute = (byte)32;
    private Vector ExtraExtHeaders = null;

    private LhaHeader() {
    }

    public LhaHeader(String path) {
        this(path, new Date(System.currentTimeMillis()));
    }

    public LhaHeader(String path, Date date) {
        this();
        if (path != null && !path.equals("") && date != null) {
            if (path.endsWith(File.separator)) {
                this.Method = "-lhd-";
            }
        } else {
            if (path == null) {
                throw new NullPointerException("path");
            }
            if (path.equals("")) {
                throw new IllegalArgumentException("path must not be empty.");
            }
            throw new NullPointerException("date");
        }
        this.Path = path;
        this.LastModified = date;
    }

    public LhaHeader(byte[] HeaderData) {
        this();
        if (HeaderData != null) {
            try {
                this.importHeader(HeaderData, LhaProperty.encoding);
            }
            catch (UnsupportedEncodingException exception) {
                throw new Error("Java Runtime Environment not support " + LhaProperty.encoding + " encoding");
            }
        } else {
            throw new NullPointerException("HeaderData");
        }
    }

    public LhaHeader(byte[] HeaderData, String encode) throws UnsupportedEncodingException {
        this();
        if (HeaderData == null || encode == null) {
            if (HeaderData == null) {
                throw new NullPointerException("HeaderData");
            }
            throw new NullPointerException("encode");
        }
        this.importHeader(HeaderData, encode);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new Error("java.lang.Object is not support clone().");
        }
    }

    public String getCompressMethod() {
        return this.Method;
    }

    public long getOriginalSize() {
        return this.OriginalSize;
    }

    public long getCompressedSize() {
        return this.CompressedSize;
    }

    public Date getLastModified() {
        return new Date(this.LastModified.getTime());
    }

    public int getHeaderLevel() {
        return this.HeaderLevel;
    }

    public String getPath() {
        return this.Path;
    }

    public int getCRC() {
        return this.CRC;
    }

    public byte getOSID() {
        return this.OSID;
    }

    protected byte[] getExtraData() {
        return (byte[])this.ExtraData.clone();
    }

    protected byte getLevel0DosAttribute() {
        return this.Level0DosAttribute;
    }

    private String getFileName() {
        return this.Path.substring(this.Path.lastIndexOf(File.separatorChar) + 1);
    }

    private String getDirName() {
        return this.Path.substring(0, this.Path.lastIndexOf(File.separatorChar) + 1);
    }

    public byte[] getBytes() {
        try {
            return this.exportHeader(LhaProperty.encoding);
        }
        catch (UnsupportedEncodingException exception) {
            throw new Error("Java Runtime Environment not support " + LhaProperty.encoding + " encoding");
        }
    }

    public byte[] getBytes(String encode) throws UnsupportedEncodingException {
        return this.exportHeader(encode);
    }

    public void setCompressMethod(String method) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (!method.startsWith("-") || !method.endsWith("-")) {
            throw new IllegalArgumentException("method must starts with '-' and ends with '-'");
        }
        this.Method = method;
    }

    public void setOriginalSize(long size) {
        if (size == -1L) {
            throw new IllegalArgumentException("size must not LhaHeader.UNKNOWN( -1 )");
        }
        this.OriginalSize = size;
    }

    public void setCompressedSize(long size) {
        if (size == -1L) {
            throw new IllegalArgumentException("size must not LhaHeader.UNKNOWN( -1 )");
        }
        this.CompressedSize = size;
    }

    public void setLastModified(Date date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        this.LastModified = date;
    }

    public void setHeaderLevel(int level) {
        this.HeaderLevel = level;
    }

    public void setPath(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (path.equals("")) {
            throw new IllegalArgumentException("path must not empty.");
        }
        this.Path = path;
    }

    public void setCRC(int crc) {
        if (crc == -1) {
            throw new IllegalArgumentException("crc must not LhaHeader.UNKNOWN( -1 )");
        }
        this.CRC = crc;
    }

    public void setOSID(byte id) {
        this.OSID = id;
    }

    protected void setExtraData(byte[] data) {
        this.ExtraData = data;
    }

    protected void setLevel0DosAttribute(byte attribute) {
        this.Level0DosAttribute = attribute;
    }

    private void setFileName(String filename) {
        this.Path = String.valueOf(this.getDirName()) + filename;
    }

    private void setDirName(String dirname) {
        this.Path = String.valueOf(dirname) + this.getFileName();
    }

    private void importLevel0Header(byte[] HeaderData, String encode) throws UnsupportedEncodingException {
        boolean HeaderSizeIndex = false;
        int HeaderSize = (HeaderData[0] & 0xFF) + 2;
        int CompressMethodIndex = 2;
        int CompressedSizeIndex = 7;
        int OriginalSizeIndex = 11;
        int LastModifiedIndex = 15;
        int DosAttributeIndex = 19;
        int HeaderLevelIndex = 20;
        int PathLengthIndex = 21;
        int PathLength = HeaderData[21] & 0xFF;
        int PathIndex = 22;
        int CRCIndex = 22 + PathLength;
        int ExtraDataIndex = 24 + PathLength;
        int ExtraDataLength = HeaderSize - ExtraDataIndex;
        this.Method = new String(HeaderData, 2, 5, encode);
        this.CompressedSize = (long)LittleEndian.readInt(HeaderData, 7) & 0xFFFFFFFFL;
        this.OriginalSize = (long)LittleEndian.readInt(HeaderData, 11) & 0xFFFFFFFFL;
        this.LastModified = new MsdosDate(LittleEndian.readInt(HeaderData, 15));
        this.Level0DosAttribute = HeaderData[19];
        this.HeaderLevel = HeaderData[20] & 0xFF;
        this.Path = new String(HeaderData, 22, PathLength, encode);
        this.Path = this.Path.replace('\\', File.separatorChar);
        if (CRCIndex + 2 <= HeaderSize) {
            this.CRC = LittleEndian.readShort(HeaderData, CRCIndex);
            if (ExtraDataLength > 0) {
                this.ExtraData = new byte[ExtraDataLength];
                System.arraycopy(HeaderData, ExtraDataIndex, this.ExtraData, 0, ExtraDataLength);
            }
        } else {
            this.CRC = -2;
        }
    }

    private void importLevel1Header(byte[] HeaderData, String encode) throws UnsupportedEncodingException {
        boolean BaseHeaderSizeIndex = false;
        int BaseHeaderSize = (HeaderData[0] & 0xFF) + 2;
        int CompressMethodIndex = 2;
        int SkipSizeIndex = 7;
        int OriginalSizeIndex = 11;
        int LastModifiedIndex = 15;
        int HeaderLevelIndex = 20;
        int FileNameLengthIndex = 21;
        int FileNameLength = HeaderData[21] & 0xFF;
        int FileNameIndex = 22;
        int CRCIndex = 22 + FileNameLength;
        int OSIDIndex = 24 + FileNameLength;
        int ExtraDataIndex = 25 + FileNameLength;
        int ExtraDataLength = BaseHeaderSize - ExtraDataIndex - 2;
        this.Method = new String(HeaderData, 2, 5, encode);
        this.CompressedSize = (long)LittleEndian.readInt(HeaderData, 7) & 0xFFFFFFFFL;
        this.OriginalSize = (long)LittleEndian.readInt(HeaderData, 11) & 0xFFFFFFFFL;
        this.LastModified = new MsdosDate(LittleEndian.readInt(HeaderData, 15));
        this.HeaderLevel = HeaderData[20] & 0xFF;
        this.Path = new String(HeaderData, 22, FileNameLength, encode);
        this.CRC = LittleEndian.readShort(HeaderData, CRCIndex);
        this.OSID = HeaderData[OSIDIndex];
        if (ExtraDataLength > 0) {
            this.ExtraData = new byte[ExtraDataLength];
            System.arraycopy(HeaderData, ExtraDataIndex, this.ExtraData, 0, ExtraDataLength);
        }
        boolean hasFileSize = false;
        int index = BaseHeaderSize;
        int length = LittleEndian.readShort(HeaderData, index - 2);
        while (length != 0) {
            if (!hasFileSize) {
                this.CompressedSize -= (long)length;
            }
            this.importExtHeader(HeaderData, index, length - 2, encode);
            if (HeaderData[index] == 66) {
                hasFileSize = true;
            }
            length = LittleEndian.readShort(HeaderData, (index += length) - 2);
        }
    }

    private void importLevel2Header(byte[] HeaderData, String encode) throws UnsupportedEncodingException {
        boolean HeaderSizeIndex = false;
        int HeaderSize = LittleEndian.readShort(HeaderData, 0);
        int CompressMethodIndex = 2;
        int CompressedSizeIndex = 7;
        int OriginalSizeIndex = 11;
        int LastModifiedIndex = 15;
        int HeaderLevelIndex = 20;
        int CRCIndex = 21;
        int OSIDIndex = 23;
        this.Method = new String(HeaderData, 2, 5, encode);
        this.CompressedSize = (long)LittleEndian.readInt(HeaderData, 7) & 0xFFFFFFFFL;
        this.OriginalSize = (long)LittleEndian.readInt(HeaderData, 11) & 0xFFFFFFFFL;
        this.LastModified = new Date((long)LittleEndian.readInt(HeaderData, 15) * 1000L);
        this.HeaderLevel = HeaderData[20] & 0xFF;
        this.CRC = LittleEndian.readShort(HeaderData, 21);
        this.OSID = HeaderData[23];
        int BaseHeaderSize = 26;
        int index = 26;
        int length = LittleEndian.readShort(HeaderData, index - 2);
        while (length != 0) {
            this.importExtHeader(HeaderData, index, length - 2, encode);
            length = LittleEndian.readShort(HeaderData, (index += length) - 2);
        }
    }

    private void importLevel3Header(byte[] HeaderData, String encode) throws UnsupportedEncodingException {
        boolean WordSizeIndex = false;
        int WordSize = LittleEndian.readShort(HeaderData, 0);
        int CompressMethodIndex = 2;
        int CompressedSizeIndex = 7;
        int OriginalSizeIndex = 11;
        int LastModifiedIndex = 15;
        int HeaderLevelIndex = 20;
        int CRCIndex = 21;
        int OSIDIndex = 23;
        this.Method = new String(HeaderData, 2, 5, encode);
        this.CompressedSize = (long)LittleEndian.readInt(HeaderData, 7) & 0xFFFFFFFFL;
        this.OriginalSize = (long)LittleEndian.readInt(HeaderData, 11) & 0xFFFFFFFFL;
        this.LastModified = new Date((long)LittleEndian.readInt(HeaderData, 15) * 1000L);
        this.HeaderLevel = HeaderData[20] & 0xFF;
        this.CRC = LittleEndian.readShort(HeaderData, 21);
        this.OSID = HeaderData[23];
        int BaseHeaderSize = 32;
        int index = 32;
        int length = LittleEndian.readInt(HeaderData, index - 4);
        while (length != 0) {
            this.importExtHeader(HeaderData, index, length - 4, encode);
            length = LittleEndian.readInt(HeaderData, (index += length) - 4);
        }
    }

    private void importHeader(byte[] HeaderData, String encode) throws UnsupportedEncodingException {
        int HeaderLevelIndex = 20;
        switch (HeaderData[20]) {
            case 0: {
                this.importLevel0Header(HeaderData, encode);
                break;
            }
            case 1: {
                this.importLevel1Header(HeaderData, encode);
                break;
            }
            case 2: {
                this.importLevel2Header(HeaderData, encode);
                break;
            }
            case 3: {
                this.importLevel3Header(HeaderData, encode);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown header level \"" + HeaderData[20] + "\".");
            }
        }
    }

    private void importCommonExtHeader(byte[] HeaderData, int index, int length) {
        if (3 < length) {
            if (this.ExtraExtHeaders == null) {
                this.ExtraExtHeaders = new Vector();
            }
            byte[] ExtHeaderData = new byte[length];
            System.arraycopy(HeaderData, index, ExtHeaderData, 0, length);
            this.ExtraExtHeaders.addElement(ExtHeaderData);
        }
    }

    private void importFileNameExtHeader(byte[] HeaderData, int index, int length, String encode) throws UnsupportedEncodingException {
        this.setFileName(new String(HeaderData, index + 1, length - 1, encode));
    }

    private void importDirNameExtHeader(byte[] HeaderData, int index, int length, String encode) throws UnsupportedEncodingException {
        int LhaFileSeparator = -1;
        int off = 1;
        String dir = "";
        while (off < length) {
            int len = 0;
            while (off + len < length) {
                if (HeaderData[index + off + len] == -1) break;
                ++len;
            }
            dir = off + len < length ? String.valueOf(dir) + new String(HeaderData, index + off, len, encode) + File.separator : String.valueOf(dir) + new String(HeaderData, index + off, len, encode);
            off += len + 1;
        }
        this.setDirName(dir);
    }

    private void importFileSizeHeader(byte[] HeaderData, int index, int length) {
        if (length == 17) {
            this.CompressedSize = LittleEndian.readLong(HeaderData, index + 1);
            this.OriginalSize = LittleEndian.readLong(HeaderData, index + 9);
        }
    }

    protected void importExtendHeader(byte[] HeaderData, int index, int length, String encode) throws UnsupportedEncodingException {
        if (this.ExtraExtHeaders == null) {
            this.ExtraExtHeaders = new Vector();
        }
        byte[] ExtHeaderData = new byte[length];
        System.arraycopy(HeaderData, index, ExtHeaderData, 0, length);
        this.ExtraExtHeaders.addElement(ExtHeaderData);
    }

    private void importExtHeader(byte[] HeaderData, int index, int length, String encode) throws UnsupportedEncodingException {
        boolean ExtendHeaderIDIndex = false;
        switch (HeaderData[index + 0]) {
            case 0: {
                this.importCommonExtHeader(HeaderData, index, length);
                break;
            }
            case 1: {
                this.importFileNameExtHeader(HeaderData, index, length, encode);
                break;
            }
            case 2: {
                this.importDirNameExtHeader(HeaderData, index, length, encode);
                break;
            }
            case 66: {
                this.importFileSizeHeader(HeaderData, index, length);
                break;
            }
            default: {
                this.importExtendHeader(HeaderData, index, length, encode);
            }
        }
    }

    private byte[] exportLevel0Header(String encode) throws UnsupportedEncodingException {
        byte[] HeaderData;
        int LHarcHeaderSize = 100;
        int CRCLength = this.CRC == -2 || this.CRC == -1 ? 0 : 2;
        byte[] CompressMethod2 = this.Method.getBytes(encode);
        MsdosDate dosDate = null;
        try {
            dosDate = this.LastModified instanceof MsdosDate ? (MsdosDate)this.LastModified : new MsdosDate(this.LastModified);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalStateException(exception.toString());
        }
        byte[] PathData = this.Path.replace(File.separatorChar, '\\').getBytes(encode);
        int HeaderLength = 22 + CRCLength + PathData.length;
        byte[] ExtraData = CRCLength != 0 && this.ExtraData != null && HeaderLength + this.ExtraData.length <= 100 ? this.ExtraData : new byte[]{};
        HeaderLength += ExtraData.length;
        if (CompressMethod2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (100 < HeaderLength) {
            throw new IllegalStateException("Header size too large.");
        }
        if (this.CompressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.CompressedSize) {
            throw new IllegalStateException("CompressedSize must be 0xFFFFFFFF or less.");
        }
        if (this.CompressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.OriginalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.OriginalSize) {
            throw new IllegalStateException("OriginalSize must be 0xFFFFFFFF or less.");
        }
        if (this.OriginalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(HeaderLength - 2);
            out.write(0);
            out.write(CompressMethod2);
            LittleEndian.writeInt(out, (int)this.CompressedSize);
            LittleEndian.writeInt(out, (int)this.OriginalSize);
            LittleEndian.writeInt(out, dosDate.getMsdosTime());
            out.write(this.Level0DosAttribute);
            out.write(this.HeaderLevel);
            out.write(PathData.length);
            out.write(PathData);
            if (this.CRC != -1) {
                LittleEndian.writeShort(out, this.CRC);
                out.write(ExtraData);
            }
            out.close();
            HeaderData = out.toByteArray();
        }
        catch (IOException exception) {
            throw new Error("caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        boolean ChecksumIndex = true;
        HeaderData[1] = (byte)LhaHeader.calcHeaderChecksum(HeaderData);
        return HeaderData;
    }

    private byte[] exportLevel1Header(String encode) throws UnsupportedEncodingException {
        byte[] HeaderData;
        MsdosDate dosDate;
        int LHarcHeaderSize = 100;
        boolean hasFileName = false;
        boolean hasCRC = false;
        byte[] CompressMethod2 = this.Method.getBytes(encode);
        try {
            dosDate = this.LastModified instanceof MsdosDate ? (MsdosDate)this.LastModified : new MsdosDate(this.LastModified);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalStateException(exception.toString());
        }
        int HeaderLength = 27;
        byte[] ExtraData = this.ExtraData != null && HeaderLength + this.ExtraData.length <= 100 ? this.ExtraData : new byte[]{};
        byte[] FileName = this.getFileName().getBytes(encode);
        if (100 < (HeaderLength += ExtraData.length) + FileName.length) {
            FileName = new byte[]{};
        } else {
            hasFileName = true;
        }
        HeaderLength += FileName.length;
        byte[][] ExtendHeaders = this.exportExtHeaders(encode);
        long SkipSize = this.CompressedSize;
        int i = 0;
        while (i < ExtendHeaders.length) {
            if (ExtendHeaders[i].length == 0 || 65534 <= ExtendHeaders[i].length || ExtendHeaders[i][0] == 1 && hasFileName) {
                ExtendHeaders[i] = null;
            } else {
                if (ExtendHeaders[i][0] == 0) {
                    hasCRC = true;
                }
                if (ExtendHeaders[i][0] == 1) {
                    hasFileName = true;
                }
                SkipSize += (long)(ExtendHeaders[i].length + 2);
            }
            ++i;
        }
        if (CompressMethod2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (SkipSize != this.CompressedSize && !hasCRC) {
            throw new IllegalStateException("no Header CRC field.");
        }
        if (!hasFileName) {
            throw new IllegalStateException("no Filename infomation.");
        }
        if (this.CRC == -2) {
            throw new IllegalStateException("no CRC value.");
        }
        if (this.CRC == -1) {
            throw new IllegalStateException("CRC is UNKNOWN.");
        }
        if (this.CompressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.CompressedSize) {
            throw new IllegalStateException("CompressedSize must be 0xFFFFFFFF or less.");
        }
        if (this.CompressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.OriginalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.OriginalSize) {
            throw new IllegalStateException("OriginalSize must be 0xFFFFFFFF or less.");
        }
        if (this.OriginalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        if (0x100000000L <= SkipSize) {
            throw new IllegalStateException("SkipSize must be 0xFFFFFFFF or less.");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(HeaderLength - 2);
            out.write(0);
            out.write(CompressMethod2);
            LittleEndian.writeInt(out, (int)SkipSize);
            LittleEndian.writeInt(out, (int)this.OriginalSize);
            LittleEndian.writeInt(out, dosDate.getMsdosTime());
            out.write(32);
            out.write(this.HeaderLevel);
            out.write(FileName.length);
            out.write(FileName);
            LittleEndian.writeShort(out, this.CRC);
            out.write(this.OSID);
            out.write(ExtraData);
            int i2 = 0;
            while (i2 < ExtendHeaders.length) {
                if (ExtendHeaders[i2] != null) {
                    LittleEndian.writeShort(out, ExtendHeaders[i2].length + 2);
                    out.write(ExtendHeaders[i2]);
                }
                ++i2;
            }
            LittleEndian.writeShort(out, 0);
            out.close();
            HeaderData = out.toByteArray();
        }
        catch (IOException exception) {
            throw new Error("caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        boolean ChecksumIndex = true;
        int CRCIndex = LhaHeader.getCRC16Position(HeaderData);
        HeaderData[1] = (byte)LhaHeader.calcHeaderChecksum(HeaderData);
        if (hasCRC) {
            LittleEndian.writeShort(HeaderData, CRCIndex, LhaHeader.calcHeaderCRC16(HeaderData));
        }
        return HeaderData;
    }

    private byte[] exportLevel2Header(String encode) throws UnsupportedEncodingException {
        byte[] HeaderData;
        int MaxHeaderLength = 65535;
        boolean hasFileName = false;
        boolean hasCRC = false;
        boolean needExtraByte = false;
        boolean hasFileSize = false;
        byte[] CompressMethod2 = this.Method.getBytes(encode);
        int HeaderLength = 26;
        boolean needFileSize = 0x100000000L <= this.CompressedSize || 0x100000000L <= this.OriginalSize;
        byte[][] ExtendHeaders = this.exportExtHeaders(encode);
        int i = 0;
        while (i < ExtendHeaders.length) {
            if (ExtendHeaders[i].length == 0 || 65535 <= HeaderLength + ExtendHeaders[i].length + 2) {
                ExtendHeaders[i] = null;
            } else {
                if (ExtendHeaders[i][0] == 0) {
                    hasCRC = true;
                }
                if (ExtendHeaders[i][0] == 1) {
                    hasFileName = true;
                }
                if (ExtendHeaders[i][0] == 66) {
                    hasFileSize = true;
                }
                HeaderLength += ExtendHeaders[i].length + 2;
            }
            ++i;
        }
        if ((HeaderLength & 0xFF) == 0) {
            ++HeaderLength;
            needExtraByte = true;
        }
        if (CompressMethod2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (this.LastModified.getTime() < 0L || (this.LastModified.getTime() / 1000L & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("LastModified can not change to 4byte time_t format.");
        }
        if (!hasCRC) {
            throw new IllegalStateException("HeaderSize too large. can not contain CRC of the Header.");
        }
        if (!hasFileName) {
            throw new IllegalStateException("HeaderSize too large. can not contain Filename.");
        }
        if (needFileSize && !hasFileSize) {
            throw new IllegalStateException("HeaderSize too large. can not contain Filesize.");
        }
        if (this.CRC == -2) {
            throw new IllegalStateException("no CRC.");
        }
        if (this.CRC == -1) {
            throw new IllegalStateException("CRC must not be UNKNOWN.");
        }
        if (this.CompressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (this.CompressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.OriginalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (this.OriginalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LittleEndian.writeShort(out, HeaderLength);
            out.write(CompressMethod2);
            LittleEndian.writeInt(out, (int)this.CompressedSize);
            LittleEndian.writeInt(out, (int)this.OriginalSize);
            LittleEndian.writeInt(out, (int)(this.LastModified.getTime() / 1000L));
            out.write(32);
            out.write(this.HeaderLevel);
            LittleEndian.writeShort(out, this.CRC);
            out.write(this.OSID);
            int i2 = 0;
            while (i2 < ExtendHeaders.length) {
                if (ExtendHeaders[i2] != null) {
                    LittleEndian.writeShort(out, ExtendHeaders[i2].length + 2);
                    out.write(ExtendHeaders[i2]);
                }
                ++i2;
            }
            LittleEndian.writeShort(out, 0);
            if (needExtraByte) {
                out.write(0);
            }
            out.close();
            HeaderData = out.toByteArray();
        }
        catch (IOException exception) {
            throw new Error("caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        int CRCIndex = LhaHeader.getCRC16Position(HeaderData);
        LittleEndian.writeShort(HeaderData, CRCIndex, LhaHeader.calcHeaderCRC16(HeaderData));
        return HeaderData;
    }

    private byte[] exportLevel3Header(String encode) throws UnsupportedEncodingException {
        byte[] HeaderData;
        int WordSize = 4;
        byte[] CompressMethod2 = this.Method.getBytes(encode);
        int HeaderLength = 32;
        byte[][] ExtendHeaders = this.exportExtHeaders(encode);
        int i = 0;
        while (i < ExtendHeaders.length) {
            if (ExtendHeaders[i].length == 0) {
                ExtendHeaders[i] = null;
            } else {
                HeaderLength += ExtendHeaders[i].length + 4;
            }
            ++i;
        }
        if (CompressMethod2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (this.LastModified.getTime() < 0L || (this.LastModified.getTime() / 1000L & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("LastModified can not change to 4byte time_t format.");
        }
        if (this.CRC == -2) {
            throw new IllegalStateException("no CRC value.");
        }
        if (this.CRC == -1) {
            throw new IllegalStateException("CRC is UNKNOWN.");
        }
        if (this.CompressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.CompressedSize) {
            throw new IllegalStateException("CompressedSize must be 0xFFFFFFFF or less.");
        }
        if (this.CompressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.OriginalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.OriginalSize) {
            throw new IllegalStateException("OriginalSize must be 0xFFFFFFFF or less.");
        }
        if (this.OriginalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LittleEndian.writeShort(out, 4);
            out.write(CompressMethod2);
            LittleEndian.writeInt(out, (int)this.CompressedSize);
            LittleEndian.writeInt(out, (int)this.OriginalSize);
            LittleEndian.writeInt(out, (int)(this.LastModified.getTime() / 1000L));
            out.write(32);
            out.write(this.HeaderLevel);
            LittleEndian.writeShort(out, this.CRC);
            out.write(this.OSID);
            LittleEndian.writeInt(out, HeaderLength);
            int i2 = 0;
            while (i2 < ExtendHeaders.length) {
                if (ExtendHeaders[i2] != null) {
                    LittleEndian.writeInt(out, ExtendHeaders[i2].length + 4);
                    out.write(ExtendHeaders[i2]);
                }
                ++i2;
            }
            LittleEndian.writeInt(out, 0);
            out.close();
            HeaderData = out.toByteArray();
        }
        catch (IOException exception) {
            throw new Error("caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        int CRCIndex = LhaHeader.getCRC16Position(HeaderData);
        LittleEndian.writeShort(HeaderData, CRCIndex, LhaHeader.calcHeaderCRC16(HeaderData));
        return HeaderData;
    }

    private byte[] exportHeader(String encode) throws UnsupportedEncodingException {
        switch (this.HeaderLevel) {
            case 0: {
                return this.exportLevel0Header(encode);
            }
            case 1: {
                return this.exportLevel1Header(encode);
            }
            case 2: {
                return this.exportLevel2Header(encode);
            }
            case 3: {
                return this.exportLevel3Header(encode);
            }
        }
        throw new IllegalStateException("unknown header level \"" + this.HeaderLevel + "\".");
    }

    private byte[] exportCommonExtHeader() {
        if (this.ExtraExtHeaders != null) {
            int i = 0;
            while (i < this.ExtraExtHeaders.size()) {
                byte[] ExtendHeaderData = (byte[])this.ExtraExtHeaders.elementAt(i);
                if (ExtendHeaderData[0] == 0) {
                    return ExtendHeaderData;
                }
                ++i;
            }
        }
        return new byte[3];
    }

    private byte[] exportFileNameExtHeader(String encode) throws UnsupportedEncodingException {
        byte[] FileName = this.getFileName().getBytes(encode);
        byte[] ExtendHeaderData = new byte[FileName.length + 1];
        ExtendHeaderData[0] = 1;
        System.arraycopy(FileName, 0, ExtendHeaderData, 1, FileName.length);
        return ExtendHeaderData;
    }

    private byte[] exportDirNameExtHeader(String encode) throws UnsupportedEncodingException {
        int LhaFileSeparator = -1;
        String dir = this.getDirName();
        Vector<byte[]> vec = new Vector<byte[]>();
        int index = 0;
        int len = 0;
        int length = 0;
        while (index + len < dir.length()) {
            if (dir.charAt(index + len) == File.separatorChar) {
                byte[] src = dir.substring(index, index + len).getBytes(encode);
                byte[] array = new byte[src.length + 1];
                System.arraycopy(src, 0, array, 0, src.length);
                array[src.length] = -1;
                length += array.length;
                vec.addElement(array);
                index += len + 1;
                len = 0;
                continue;
            }
            if (index + len + 1 < dir.length()) {
                byte[] array = dir.substring(index, index + len + 1).getBytes(encode);
                length += array.length;
                vec.addElement(array);
                index += len + 1;
                len = 0;
                continue;
            }
            ++len;
        }
        byte[] ExtendHeaderData = new byte[length + 1];
        ExtendHeaderData[0] = 2;
        index = 1;
        int i = 0;
        while (i < vec.size()) {
            byte[] array = (byte[])vec.elementAt(i);
            System.arraycopy(array, 0, ExtendHeaderData, index, array.length);
            index += array.length;
            ++i;
        }
        return ExtendHeaderData;
    }

    private byte[] exportFileSizeHeader() {
        byte[] ExtendHeaderData = new byte[17];
        ExtendHeaderData[0] = 66;
        LittleEndian.writeLong(ExtendHeaderData, 1, this.CompressedSize);
        LittleEndian.writeLong(ExtendHeaderData, 9, this.OriginalSize);
        return ExtendHeaderData;
    }

    protected byte[][] exportExtendHeaders(String encode) throws UnsupportedEncodingException {
        if (this.ExtraExtHeaders != null) {
            byte[][] ExtendHeaders = new byte[this.ExtraExtHeaders.size()][];
            int i = 0;
            while (i < this.ExtraExtHeaders.size()) {
                ExtendHeaders[i] = (byte[])this.ExtraExtHeaders.elementAt(i);
                ++i;
            }
            return ExtendHeaders;
        }
        return new byte[0][];
    }

    private byte[][] exportExtHeaders(String encode) throws UnsupportedEncodingException {
        byte[] CommonExtHeader = this.exportCommonExtHeader();
        byte[] FileNameExtHeader = this.exportFileNameExtHeader(encode);
        byte[] DirNameExtHeader = this.exportDirNameExtHeader(encode);
        byte[][] ExtraExtHeaders = this.exportExtendHeaders(encode);
        Vector<byte[]> Headers = new Vector<byte[]>();
        Headers.addElement(CommonExtHeader);
        Headers.addElement(FileNameExtHeader);
        if (1 < DirNameExtHeader.length) {
            Headers.addElement(DirNameExtHeader);
        }
        if (this.HeaderLevel == 2 && (0x100000000L <= this.CompressedSize || 0x100000000L <= this.OriginalSize)) {
            Headers.addElement(this.exportFileSizeHeader());
        }
        int i = 0;
        while (i < ExtraExtHeaders.length) {
            byte[] ExtendHeaderData = ExtraExtHeaders[i];
            if (ExtendHeaderData.length > 0 && ExtendHeaderData[0] != 0 && ExtendHeaderData[0] != 1 && ExtendHeaderData[0] != 2) {
                Headers.addElement(ExtendHeaderData);
            }
            ++i;
        }
        byte[][] ExtendHeaders = new byte[Headers.size()][];
        int i2 = 0;
        while (i2 < ExtendHeaders.length) {
            ExtendHeaders[i2] = (byte[])Headers.elementAt(i2);
            ++i2;
        }
        return ExtendHeaders;
    }

    public static boolean checkHeaderData(byte[] HeaderData) {
        int HeaderLevelIndex = 20;
        try {
            switch (HeaderData[20] & 0xFF) {
                case 0: {
                    return LhaHeader.verifyHeaderChecksum(HeaderData);
                }
                case 1: {
                    return LhaHeader.verifyHeaderChecksum(HeaderData) && (LhaHeader.getCRC16Position(HeaderData) == -1 || LhaHeader.verifyHeaderCRC16(HeaderData));
                }
                case 2: {
                    return LhaHeader.verifyHeaderCRC16(HeaderData);
                }
                case 3: {
                    return LhaHeader.verifyHeaderCRC16(HeaderData);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int getCRC16Position(byte[] HeaderData) {
        int position;
        int length;
        int WordSize;
        int HeaderLevelIndex = 20;
        switch (HeaderData[20] & 0xFF) {
            case 1: {
                WordSize = 2;
                position = length = (HeaderData[0] & 0xFF) + 2;
                break;
            }
            case 2: {
                WordSize = 2;
                length = 26;
                position = 26;
                break;
            }
            case 3: {
                WordSize = 4;
                length = 32;
                position = 32;
                break;
            }
            default: {
                return -1;
            }
        }
        while (length > 0 && position < HeaderData.length) {
            length = 0;
            int i = 0;
            while (i < WordSize) {
                length = length << 8 | HeaderData[position - (1 + i)] & 0xFF;
                ++i;
            }
            if (HeaderData[position] == 0) {
                return position + 1;
            }
            position += length;
        }
        return -1;
    }

    private static int calcHeaderChecksum(byte[] HeaderData) {
        int length = HeaderData[0] & 0xFF;
        LhaChecksum checksum = new LhaChecksum();
        checksum.update(HeaderData, 2, length);
        return (int)checksum.getValue();
    }

    private static int calcHeaderCRC16(byte[] HeaderData) {
        int position = LhaHeader.getCRC16Position(HeaderData);
        int crcValue = 0;
        if (position != -1) {
            crcValue = LittleEndian.readShort(HeaderData, position);
            LittleEndian.writeShort(HeaderData, position, 0);
        }
        CRC16 crc16 = new CRC16();
        crc16.update(HeaderData);
        if (position != -1) {
            LittleEndian.writeShort(HeaderData, position, crcValue);
        }
        return (int)crc16.getValue();
    }

    private static int readHeaderChecksum(byte[] HeaderData) {
        return HeaderData[1] & 0xFF;
    }

    private static int readHeaderCRC16(byte[] HeaderData) {
        int position = LhaHeader.getCRC16Position(HeaderData);
        if (position != -1) {
            return LittleEndian.readShort(HeaderData, position);
        }
        return -1;
    }

    private static boolean verifyHeaderChecksum(byte[] HeaderData) {
        int HeaderLevelIndex = 20;
        switch (HeaderData[20] & 0xFF) {
            case 0: 
            case 1: {
                return LhaHeader.readHeaderChecksum(HeaderData) == LhaHeader.calcHeaderChecksum(HeaderData);
            }
        }
        return false;
    }

    private static boolean verifyHeaderCRC16(byte[] HeaderData) {
        int HeaderLevelIndex = 20;
        switch (HeaderData[20] & 0xFF) {
            case 1: 
            case 2: 
            case 3: {
                return LhaHeader.readHeaderCRC16(HeaderData) == LhaHeader.calcHeaderCRC16(HeaderData);
            }
        }
        return false;
    }

    public static byte[] getFirstHeaderData(InputStream in) throws IOException {
        if (in.markSupported()) {
            try {
                int read;
                int stock1 = -1;
                int stock2 = -1;
                while ((read = in.read()) >= 0) {
                    if (read == 45 && stock1 > 0) {
                        in.mark(65536);
                        LhaHeader.ensureSkip(in, 3L);
                        if (in.read() == 45) {
                            byte[] HeaderData;
                            LhaHeader.ensureSkip(in, 13L);
                            int HeaderLevel = in.read();
                            in.reset();
                            switch (HeaderLevel) {
                                case 0: {
                                    HeaderData = LhaHeader.readLevel0HeaderData(stock1, stock2, read, in);
                                    break;
                                }
                                case 1: {
                                    HeaderData = LhaHeader.readLevel1HeaderData(stock1, stock2, read, in);
                                    break;
                                }
                                case 2: {
                                    HeaderData = LhaHeader.readLevel2HeaderData(stock1, stock2, read, in);
                                    break;
                                }
                                case 3: {
                                    HeaderData = LhaHeader.readLevel3HeaderData(stock1, stock2, read, in);
                                    break;
                                }
                                default: {
                                    HeaderData = null;
                                }
                            }
                            if (HeaderData != null && LhaHeader.checkHeaderData(HeaderData)) {
                                return HeaderData;
                            }
                        }
                        in.reset();
                    }
                    stock1 = stock2;
                    stock2 = read;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return null;
        }
        throw new IllegalArgumentException("InputStream needed mark()/reset() support.");
    }

    public static byte[] getNextHeaderData(InputStream in) throws IOException {
        if (in.markSupported()) {
            try {
                int first = in.read();
                if (first > 0) {
                    int second = in.read();
                    int third = in.read();
                    in.mark(65536);
                    LhaHeader.ensureSkip(in, 3L);
                    int seventh = in.read();
                    if (third == 45 && seventh == 45) {
                        byte[] HeaderData;
                        LhaHeader.ensureSkip(in, 13L);
                        int HeaderLevel = in.read();
                        in.reset();
                        switch (HeaderLevel) {
                            case 0: {
                                HeaderData = LhaHeader.readLevel0HeaderData(first, second, third, in);
                                break;
                            }
                            case 1: {
                                HeaderData = LhaHeader.readLevel1HeaderData(first, second, third, in);
                                break;
                            }
                            case 2: {
                                HeaderData = LhaHeader.readLevel2HeaderData(first, second, third, in);
                                break;
                            }
                            case 3: {
                                HeaderData = LhaHeader.readLevel3HeaderData(first, second, third, in);
                                break;
                            }
                            default: {
                                HeaderData = null;
                            }
                        }
                        if (HeaderData != null && LhaHeader.checkHeaderData(HeaderData)) {
                            return HeaderData;
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return null;
        }
        throw new IllegalArgumentException("InputStream needed mark()/reset() support.");
    }

    private static byte[] readLevel0HeaderData(int HeaderLength, int HeaderChecksum, int CompressMethod1, InputStream in) throws IOException {
        byte[] HeaderData = new byte[HeaderLength + 2];
        HeaderData[0] = (byte)HeaderLength;
        HeaderData[1] = (byte)HeaderChecksum;
        HeaderData[2] = (byte)CompressMethod1;
        int readed = 3;
        int length = 0;
        HeaderLength += 2;
        while (readed < HeaderLength && length >= 0) {
            length = in.read(HeaderData, readed, HeaderLength - readed);
            readed += length;
        }
        if (readed == HeaderLength) {
            return HeaderData;
        }
        throw new EOFException();
    }

    private static byte[] readLevel1HeaderData(int BaseHeaderLength, int BaseHeaderChecksum, int CompressMethod1, InputStream in) throws IOException {
        int HeaderLength = BaseHeaderLength + 2;
        Vector<byte[]> headers = new Vector<byte[]>();
        byte[] HeaderData = new byte[HeaderLength];
        HeaderData[0] = (byte)BaseHeaderLength;
        HeaderData[1] = (byte)BaseHeaderChecksum;
        HeaderData[2] = (byte)CompressMethod1;
        int readed = 0;
        int length = 0;
        do {
            readed = headers.size() == 0 ? 3 : 0;
            while (readed < HeaderLength && length >= 0) {
                length = in.read(HeaderData, readed, HeaderLength - readed);
                readed += length;
            }
            if (readed == HeaderLength) {
                if (headers.size() == 0 && !LhaHeader.verifyHeaderChecksum(HeaderData)) {
                    return null;
                }
            } else {
                throw new EOFException();
            }
            headers.addElement(HeaderData);
            length = HeaderLength;
            HeaderLength = LittleEndian.readShort(HeaderData, HeaderLength - 2);
            HeaderData = new byte[HeaderLength];
        } while (HeaderLength > 0 && readed == length);
        HeaderLength = 0;
        int i = 0;
        while (i < headers.size()) {
            HeaderLength += ((byte[])headers.elementAt(i)).length;
            ++i;
        }
        HeaderData = new byte[HeaderLength];
        int position = 0;
        int i2 = 0;
        while (i2 < headers.size()) {
            byte[] Data = (byte[])headers.elementAt(i2);
            System.arraycopy(Data, 0, HeaderData, position, Data.length);
            position += Data.length;
            ++i2;
        }
        return HeaderData;
    }

    private static byte[] readLevel2HeaderData(int HeaderLengthLow, int HeaderLengthHi, int CompressMethod1, InputStream in) throws IOException {
        int HeaderLength = HeaderLengthHi << 8 | HeaderLengthLow;
        byte[] HeaderData = new byte[HeaderLength];
        HeaderData[0] = (byte)HeaderLengthLow;
        HeaderData[1] = (byte)HeaderLengthHi;
        HeaderData[2] = (byte)CompressMethod1;
        int readed = 3;
        int length = 0;
        while (readed < HeaderLength && length >= 0) {
            length = in.read(HeaderData, readed, HeaderLength - readed);
            readed += length;
        }
        if (readed == HeaderLength) {
            return HeaderData;
        }
        throw new EOFException();
    }

    private static byte[] readLevel3HeaderData(int WordSizeLow, int WordSizeHi, int CompressMethod1, InputStream in) throws IOException {
        if (WordSizeLow == 4 && WordSizeHi == 0) {
            in.skip(21L);
            int HeaderLength = LittleEndian.readInt(in);
            in.reset();
            byte[] HeaderData = new byte[HeaderLength];
            HeaderData[0] = (byte)WordSizeLow;
            HeaderData[1] = (byte)WordSizeHi;
            HeaderData[2] = (byte)CompressMethod1;
            int readed = 3;
            int length = 0;
            while (readed < HeaderLength && length >= 0) {
                length = in.read(HeaderData, readed, HeaderLength - readed);
                readed += length;
            }
            if (readed == HeaderLength) {
                return HeaderData;
            }
            throw new EOFException();
        }
        return null;
    }

    public static LhaHeader createInstance(byte[] HeaderData, Properties property) {
        String generator;
        String packages;
        String encoding = property.getProperty("lha.encoding");
        if (encoding == null) {
            encoding = LhaProperty.getProperty("lha.encoding");
        }
        if ((packages = property.getProperty("lha.packages")) == null) {
            packages = LhaProperty.getProperty("lha.packages");
        }
        if ((generator = property.getProperty("lha.header")) == null) {
            generator = LhaProperty.getProperty("lha.header");
        }
        Hashtable<String, Object> substitute = new Hashtable<String, Object>();
        substitute.put("data", HeaderData);
        substitute.put("encoding", encoding);
        return (LhaHeader)LhaProperty.parse(generator, substitute, packages);
    }

    private static void ensureSkip(InputStream in, long len) throws IOException {
        while (0L < len) {
            long skiplen = in.skip(len);
            if (skiplen <= 0L) {
                if (in.read() >= 0) {
                    --len;
                    continue;
                }
                throw new EOFException();
            }
            len -= skiplen;
        }
    }
}

