/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import org.seasar.framework.container.BindingTypeDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.BindingTypeDefFactory;
import org.seasar.framework.container.factory.AbstractTagHandler;
import org.seasar.framework.container.factory.TagAttributeNotDefinedRuntimeException;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.xml.TagHandlerContext;
import org.xml.sax.Attributes;

public class PropertyTagHandler
extends AbstractTagHandler {
    private static final long serialVersionUID = -8153752681379626269L;

    public void start(TagHandlerContext context, Attributes attributes) {
        String name = attributes.getValue("name");
        if (name == null) {
            throw new TagAttributeNotDefinedRuntimeException("property", "name");
        }
        PropertyDefImpl pd = this.createPropertyDef(name);
        String bindingTypeName = attributes.getValue("bindingType");
        if (bindingTypeName != null) {
            BindingTypeDef bindingTypeDef = BindingTypeDefFactory.getBindingTypeDef(bindingTypeName);
            pd.setBindingTypeDef(bindingTypeDef);
        }
        context.push(pd);
    }

    public void end(TagHandlerContext context, String body) {
        PropertyDef propertyDef = (PropertyDef)context.pop();
        if (!StringUtil.isEmpty(body)) {
            propertyDef.setExpression(this.createExpression(context, body));
        }
        ComponentDef componentDef = (ComponentDef)context.peek();
        componentDef.addPropertyDef(propertyDef);
    }

    protected PropertyDefImpl createPropertyDef(String name) {
        return new PropertyDefImpl(name);
    }
}

