/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.converter;

import java.util.Date;
import org.seasar.framework.beans.Converter;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.SqlDateConversionUtil;
import org.seasar.framework.util.StringConversionUtil;
import org.seasar.framework.util.StringUtil;

public class SqlDateConverter
implements Converter {
    protected String pattern;

    public SqlDateConverter(String pattern) {
        if (StringUtil.isEmpty(pattern)) {
            throw new EmptyRuntimeException("pattern");
        }
        this.pattern = pattern;
    }

    public Object getAsObject(String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        return SqlDateConversionUtil.toDate(value, this.pattern);
    }

    public String getAsString(Object value) {
        return StringConversionUtil.toString((Date)value, this.pattern);
    }

    public boolean isTarget(Class clazz) {
        return clazz == java.sql.Date.class;
    }
}

