/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableLookup {
    private static Logger log = LoggerFactory.getLogger(TableLookup.class);
    private static final boolean showErrors = true;
    private TableB localTableB;
    private TableD localTableD;
    private TableB wmoTableB;
    private TableD wmoTableD;
    public BufrTables.Mode mode = BufrTables.Mode.wmoOnly;

    public TableLookup(BufrIdentificationSection ids) throws IOException {
        this.wmoTableB = BufrTables.getWmoTableB(ids);
        this.wmoTableD = BufrTables.getWmoTableD(ids);
        BufrTables.Tables tables = BufrTables.getLocalTables(ids);
        if (tables != null) {
            this.localTableB = tables.b;
            this.localTableD = tables.d;
            this.mode = tables.mode == null ? BufrTables.Mode.wmoOnly : tables.mode;
        }
    }

    public final String getWmoTableBName() {
        return this.wmoTableB.getName();
    }

    public final String getLocalTableBName() {
        return this.localTableB == null ? "none" : this.localTableB.getName();
    }

    public final String getLocalTableDName() {
        return this.localTableD == null ? "none" : this.localTableD.getName();
    }

    public final String getWmoTableDName() {
        return this.wmoTableD.getName();
    }

    public BufrTables.Mode getMode() {
        return this.mode;
    }

    public TableB.Descriptor getDescriptorTableB(short fxy) {
        TableB.Descriptor b = null;
        boolean isWmoRange = Descriptor.isWmoRange(fxy);
        if (isWmoRange && this.mode == BufrTables.Mode.wmoOnly) {
            b = this.wmoTableB.getDescriptor(fxy);
        } else if (isWmoRange && this.mode == BufrTables.Mode.wmoLocal) {
            b = this.wmoTableB.getDescriptor(fxy);
            if (b == null && this.localTableB != null) {
                b = this.localTableB.getDescriptor(fxy);
            }
        } else if (isWmoRange && this.mode == BufrTables.Mode.localOverride) {
            if (this.localTableB != null) {
                b = this.localTableB.getDescriptor(fxy);
            }
            if (b == null) {
                b = this.wmoTableB.getDescriptor(fxy);
            } else {
                b.setLocalOverride(true);
            }
        } else if (!isWmoRange && this.localTableB != null) {
            b = this.localTableB.getDescriptor(fxy);
        }
        if (b == null) {
            System.out.printf(" TableLookup cant find Table B descriptor = %s in tables %s, %s mode=%s%n", new Object[]{Descriptor.makeString(fxy), this.getLocalTableBName(), this.getWmoTableBName(), this.mode});
        }
        return b;
    }

    public List<Short> getDescriptorsTableD(short id) {
        TableD.Descriptor d = this.getDescriptorTableD(id);
        if (d != null) {
            return d.getSequence();
        }
        return null;
    }

    public List<String> getDescriptorsTableD(String fxy) {
        short id = Descriptor.getFxy(fxy);
        List<Short> seq = this.getDescriptorsTableD(id);
        if (seq == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(seq.size());
        for (Short s : seq) {
            result.add(Descriptor.makeString(s));
        }
        return result;
    }

    public TableD.Descriptor getDescriptorTableD(short fxy) {
        TableD.Descriptor d = null;
        boolean isWmoRange = Descriptor.isWmoRange(fxy);
        if (isWmoRange && this.mode == BufrTables.Mode.wmoOnly) {
            d = this.wmoTableD.getDescriptor(fxy);
        } else if (isWmoRange && this.mode == BufrTables.Mode.wmoLocal) {
            d = this.wmoTableD.getDescriptor(fxy);
            if (d == null && this.localTableD != null) {
                d = this.localTableD.getDescriptor(fxy);
            }
        } else if (isWmoRange && this.mode == BufrTables.Mode.localOverride) {
            if (this.localTableD != null) {
                d = this.localTableD.getDescriptor(fxy);
            }
            if (d == null) {
                d = this.wmoTableD.getDescriptor(fxy);
            } else {
                d.setLocalOverride(true);
            }
        } else if (this.localTableD != null) {
            d = this.localTableD.getDescriptor(fxy);
        }
        if (d == null) {
            System.out.printf(" TableLookup cant find Table D descriptor %s in tables %s,%s mode=%s%n", new Object[]{Descriptor.makeString(fxy), this.getLocalTableDName(), this.getWmoTableDName(), this.mode});
        }
        return d;
    }
}

