/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.extractor.impl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.ExtractData;
import org.seasar.robot.extractor.ExtractException;
import org.seasar.robot.extractor.Extractor;
import org.seasar.robot.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(TikaExtractor.class);
    public String outputEncoding = "UTF-8";
    public boolean readAsTextIfFailed = true;
    protected Map<String, String> pdfPasswordMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExtractData getText(InputStream inputStream, Map<String, String> params) {
        if (inputStream == null) {
            throw new RobotSystemException("The inputstream is null.");
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tikaExtractor-", ".out");
        }
        catch (IOException e) {
            throw new ExtractException("Could not create a temp file.", e);
        }
        try {
            try {
                String content;
                Metadata metadata;
                ByteArrayOutputStream errStream;
                PrintStream originalErrStream;
                ByteArrayOutputStream outStream;
                PrintStream originalOutStream;
                FileInputStream in;
                block45: {
                    String pdfPassword;
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(tempFile);
                        StreamUtil.drain(inputStream, out);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                    in = new FileInputStream(tempFile);
                    originalOutStream = System.out;
                    outStream = new ByteArrayOutputStream();
                    System.setOut(new PrintStream(outStream, true));
                    originalErrStream = System.err;
                    errStream = new ByteArrayOutputStream();
                    System.setErr(new PrintStream(errStream, true));
                    String resourceName = params == null ? null : params.get("resourceName");
                    String contentType = params == null ? null : params.get("Content-Type");
                    String contentEncoding = params == null ? null : params.get("Content-Encoding");
                    metadata = this.createMetadata(resourceName, contentType, contentEncoding);
                    String string = pdfPassword = params == null ? null : params.get("org.apache.tika.parser.pdf.password");
                    if (pdfPassword == null && params != null) {
                        pdfPassword = this.getPdfPassword(params.get("url"), resourceName);
                    }
                    if (pdfPassword != null) {
                        metadata.add("org.apache.tika.parser.pdf.password", pdfPassword);
                    }
                    AutoDetectParser parser = new AutoDetectParser();
                    ParseContext parseContext = new ParseContext();
                    parseContext.set(Parser.class, (Object)parser);
                    StringWriter writer = new StringWriter();
                    parser.parse((InputStream)in, (ContentHandler)new BodyContentHandler((Writer)writer), metadata, parseContext);
                    content = this.normalizeContent(writer);
                    if (StringUtil.isBlank((String)content)) {
                        if (resourceName != null) {
                            IOUtils.closeQuietly((InputStream)in);
                            in = new FileInputStream(tempFile);
                            Metadata metadata2 = this.createMetadata(null, contentType, contentEncoding);
                            StringWriter writer2 = new StringWriter();
                            parser.parse((InputStream)in, (ContentHandler)new BodyContentHandler((Writer)writer2), metadata2, parseContext);
                            content = this.normalizeContent(writer2);
                        }
                        if (StringUtil.isBlank((String)content) && contentType != null) {
                            IOUtils.closeQuietly((InputStream)in);
                            in = new FileInputStream(tempFile);
                            Metadata metadata3 = this.createMetadata(null, null, contentEncoding);
                            StringWriter writer3 = new StringWriter();
                            parser.parse((InputStream)in, (ContentHandler)new BodyContentHandler((Writer)writer3), metadata3, parseContext);
                            content = this.normalizeContent(writer3);
                        }
                        if (this.readAsTextIfFailed && StringUtil.isBlank((String)content)) {
                            Object var23_30;
                            IOUtils.closeQuietly((InputStream)in);
                            if (contentEncoding == null) {
                                contentEncoding = "UTF-8";
                            }
                            BufferedReader br = null;
                            try {
                                String line;
                                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), contentEncoding));
                                StringWriter writer4 = new StringWriter();
                                while ((line = br.readLine()) != null) {
                                    writer4.write(line.replaceAll("\\p{Cntrl}", " ").replaceAll("\\s+", " ").trim());
                                    writer4.write(32);
                                }
                                content = writer4.toString().trim();
                                var23_30 = null;
                            }
                            catch (Throwable throwable) {
                                Object var23_31 = null;
                                IOUtils.closeQuietly(br);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((Reader)br);
                            {
                                break block45;
                                catch (Exception e) {
                                    logger.warn("Could not read " + tempFile.getAbsolutePath(), (Throwable)e);
                                    var23_30 = null;
                                    IOUtils.closeQuietly((Reader)br);
                                }
                            }
                        }
                    }
                }
                ExtractData extractData = new ExtractData(content);
                Object[] names = metadata.names();
                Arrays.sort(names);
                for (Object name : names) {
                    extractData.putValues((String)name, metadata.getValues((String)name));
                }
                ExtractData extractData2 = extractData;
                Object var26_36 = null;
                IOUtils.closeQuietly((InputStream)in);
                if (originalOutStream != null) {
                    System.setOut(originalOutStream);
                }
                if (originalErrStream != null) {
                    System.setErr(originalErrStream);
                }
                try {
                    byte[] bs;
                    if (logger.isInfoEnabled() && (bs = outStream.toByteArray()).length != 0) {
                        logger.info(new String(bs, this.outputEncoding));
                    }
                    if (logger.isWarnEnabled() && (bs = errStream.toByteArray()).length != 0) {
                        logger.warn(new String(bs, this.outputEncoding));
                    }
                }
                catch (Exception e2) {
                }
                Object var29_45 = null;
                if (tempFile != null && !tempFile.delete()) {
                    tempFile.deleteOnExit();
                }
                return extractData2;
                catch (TikaException e) {
                    block47: {
                        ExtractData extractData3;
                        try {
                            Extractor xmlExtractor;
                            Throwable cause = e.getCause();
                            if (!(cause instanceof SAXException) || (xmlExtractor = (Extractor)SingletonS2Container.getComponent((String)"xmlExtractor")) == null) break block47;
                            IOUtils.closeQuietly((InputStream)in);
                            in = new FileInputStream(tempFile);
                            extractData3 = xmlExtractor.getText(in, params);
                            Object var26_37 = null;
                        }
                        catch (Throwable throwable) {
                            Object var26_38 = null;
                            IOUtils.closeQuietly((InputStream)in);
                            if (originalOutStream != null) {
                                System.setOut(originalOutStream);
                            }
                            if (originalErrStream != null) {
                                System.setErr(originalErrStream);
                            }
                            try {
                                byte[] bs;
                                if (logger.isInfoEnabled() && (bs = outStream.toByteArray()).length != 0) {
                                    logger.info(new String(bs, this.outputEncoding));
                                }
                                if (logger.isWarnEnabled() && (bs = errStream.toByteArray()).length != 0) {
                                    logger.warn(new String(bs, this.outputEncoding));
                                }
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        if (originalOutStream != null) {
                            System.setOut(originalOutStream);
                        }
                        if (originalErrStream != null) {
                            System.setErr(originalErrStream);
                        }
                        try {
                            byte[] bs;
                            if (logger.isInfoEnabled() && (bs = outStream.toByteArray()).length != 0) {
                                logger.info(new String(bs, this.outputEncoding));
                            }
                            if (logger.isWarnEnabled() && (bs = errStream.toByteArray()).length != 0) {
                                logger.warn(new String(bs, this.outputEncoding));
                            }
                        }
                        catch (Exception e2) {
                        }
                        Object var29_46 = null;
                        if (tempFile != null && !tempFile.delete()) {
                            tempFile.deleteOnExit();
                        }
                        return extractData3;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new ExtractException("Could not extract a content.", e);
            }
        }
        catch (Throwable throwable) {
            block49: {
                Object var29_47 = null;
                if (tempFile == null || tempFile.delete()) break block49;
                tempFile.deleteOnExit();
            }
            throw throwable;
        }
    }

    private String normalizeContent(StringWriter writer) {
        return writer.toString().replaceAll("\\s+", " ").trim();
    }

    String getPdfPassword(String url, String resourceName) {
        if (this.pdfPasswordMap.size() == 0) {
            return null;
        }
        String value = null;
        if (StringUtil.isNotEmpty((String)url)) {
            value = url;
        } else if (StringUtil.isNotEmpty((String)resourceName)) {
            value = resourceName;
        }
        if (value != null) {
            for (Map.Entry<String, String> entry : this.pdfPasswordMap.entrySet()) {
                if (!value.matches(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private Metadata createMetadata(String resourceName, String contentType, String contentEncoding) {
        Metadata metadata = new Metadata();
        if (StringUtil.isNotEmpty((String)resourceName)) {
            metadata.set("resourceName", resourceName);
        }
        if (StringUtil.isNotBlank((String)contentType)) {
            metadata.set("Content-Type", contentType);
        }
        if (StringUtil.isNotBlank((String)contentEncoding)) {
            metadata.set("Content-Encoding", contentEncoding);
        }
        return metadata;
    }

    public void addPdfPassword(String regex, String password) {
        this.pdfPasswordMap.put(regex, password);
    }
}

