/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.client.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.MaxLengthExceededException;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.S2RobotContext;
import org.seasar.robot.client.AbstractS2RobotClient;
import org.seasar.robot.client.http.BasicAuthentication;
import org.seasar.robot.client.http.RequestHeader;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.RobotsTxt;
import org.seasar.robot.helper.ContentLengthHelper;
import org.seasar.robot.helper.RobotsTxtHelper;
import org.seasar.robot.util.CrawlingParameterUtil;
import org.seasar.robot.util.StreamUtil;
import org.seasar.robot.util.TemporaryFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsHttpClient
extends AbstractS2RobotClient {
    public static final String CONNECTION_TIMEOUT_PROPERTY = "connectionTimeout";
    public static final String MAX_TOTAL_CONNECTIONS_PROPERTY = "maxTotalConnections";
    public static final String STALE_CHECKING_ENABLED_PROPERTY = "staleCheckingEnabled";
    public static final String SO_TIMEOUT_PROPERTY = "soTimeout";
    public static final String LINGER_PROPERTY = "linger";
    public static final String PROXY_HOST_PROPERTY = "proxyHost";
    public static final String PROXY_PORT_PROPERTY = "proxyPort";
    public static final String PROXY_CREDENTIALS_PROPERTY = "proxyCredentials";
    public static final String USER_AGENT_PROPERTY = "userAgent";
    public static final String BASIC_AUTHENTICATIONS_PROPERTY = "basicAuthentications";
    public static final String REQUERT_HEADERS_PROPERTY = "requestHeaders";
    private static final Logger logger = LoggerFactory.getLogger(CommonsHttpClient.class);
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected RobotsTxtHelper robotsTxtHelper;
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    public Integer connectionTimeout;
    public Integer maxTotalConnections;
    public Boolean staleCheckingEnabled;
    public Integer soTimeout;
    public Integer linger;
    public String cookiePolicy;
    public String userAgent = "S2Robot";
    protected volatile HttpClient httpClient;
    public String proxyHost;
    public Integer proxyPort;
    @Binding(bindingType=BindingType.MAY)
    public Credentials proxyCredentials;
    public int responseBodyInMemoryThresholdSize = 0x100000;
    private final List<Header> requestHeaderList = new ArrayList<Header>();
    public String defaultMimeType = "application/octet-stream";

    public synchronized void init() {
        RequestHeader[] requestHeaders;
        BasicAuthentication[] siteCredentialList;
        String userAgent;
        Integer linger;
        Integer soTimeout;
        Boolean staleCheckingEnabled;
        Integer maxTotalConnections;
        if (this.httpClient != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing " + CommonsHttpClient.class.getName());
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        Integer connectionTimeout = this.getInitParameter(CONNECTION_TIMEOUT_PROPERTY, this.connectionTimeout);
        if (connectionTimeout != null) {
            params.setConnectionTimeout(connectionTimeout.intValue());
        }
        if ((maxTotalConnections = this.getInitParameter(MAX_TOTAL_CONNECTIONS_PROPERTY, this.maxTotalConnections)) != null) {
            params.setMaxTotalConnections(maxTotalConnections.intValue());
        }
        if ((staleCheckingEnabled = this.getInitParameter(STALE_CHECKING_ENABLED_PROPERTY, this.staleCheckingEnabled)) != null) {
            params.setStaleCheckingEnabled(staleCheckingEnabled.booleanValue());
        }
        if ((soTimeout = this.getInitParameter(SO_TIMEOUT_PROPERTY, this.soTimeout)) != null) {
            params.setSoTimeout(soTimeout.intValue());
        }
        if ((linger = this.getInitParameter(LINGER_PROPERTY, this.linger)) != null) {
            params.setLinger(linger.intValue());
        }
        connectionManager.setParams(params);
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        String proxyHost = this.getInitParameter(PROXY_HOST_PROPERTY, this.proxyHost);
        Integer proxyPort = this.getInitParameter(PROXY_PORT_PROPERTY, this.proxyPort);
        if (proxyHost != null && proxyPort != null) {
            this.httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort.intValue());
            Credentials proxyCredentials = this.getInitParameter(PROXY_CREDENTIALS_PROPERTY, this.proxyCredentials);
            if (proxyCredentials != null) {
                this.httpClient.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort.intValue()), proxyCredentials);
            }
        }
        if (StringUtil.isNotBlank((String)(userAgent = this.getInitParameter(USER_AGENT_PROPERTY, this.userAgent)))) {
            this.httpClient.getParams().setParameter("http.useragent", (Object)userAgent);
        }
        HttpState httpState = this.httpClient.getState();
        for (BasicAuthentication basicAuthentication : siteCredentialList = this.getInitParameter(BASIC_AUTHENTICATIONS_PROPERTY, new BasicAuthentication[0])) {
            httpState.setCredentials(basicAuthentication.getAuthScope(), basicAuthentication.getCredentials());
        }
        for (RequestHeader requestHeader : requestHeaders = this.getInitParameter(REQUERT_HEADERS_PROPERTY, new RequestHeader[0])) {
            if (!requestHeader.isValid()) continue;
            this.requestHeaderList.add(new Header(requestHeader.getName(), requestHeader.getValue()));
        }
    }

    protected void processRobotsTxt(String url) {
        if (StringUtil.isBlank((String)url)) {
            throw new RobotSystemException("url is null or empty.");
        }
        if (this.robotsTxtHelper == null) {
            return;
        }
        S2RobotContext robotContext = CrawlingParameterUtil.getRobotContext();
        if (robotContext == null) {
            return;
        }
        int idx = url.indexOf(47, url.indexOf("://") + 3);
        String hostUrl = idx >= 0 ? url.substring(0, idx) : url;
        String robotTxtUrl = hostUrl + "/robots.txt";
        if (robotContext.getRobotTxtUrlSet().contains(robotTxtUrl)) {
            if (logger.isDebugEnabled()) {
                logger.debug(robotTxtUrl + " is already visited.");
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Checking URL: " + robotTxtUrl);
        }
        robotContext.getRobotTxtUrlSet().add(robotTxtUrl);
        GetMethod getMethod = new GetMethod(robotTxtUrl);
        if (this.cookiePolicy != null) {
            getMethod.getParams().setCookiePolicy(this.cookiePolicy);
        }
        for (Header header : this.requestHeaderList) {
            getMethod.setRequestHeader(header);
        }
        try {
            try {
                this.httpClient.executeMethod((HttpMethod)getMethod);
                int httpStatusCode = getMethod.getStatusCode();
                if (httpStatusCode == 200) {
                    RobotsTxt.Directives directives;
                    RobotsTxt robotsTxt;
                    Header contentLengthHeader = getMethod.getResponseHeader("Content-Length");
                    if (contentLengthHeader != null) {
                        long maxLength;
                        String value = contentLengthHeader.getValue();
                        long contentLength = Long.parseLong(value);
                        if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength("text/plain"))) {
                            throw new MaxLengthExceededException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + robotTxtUrl);
                        }
                    }
                    if ((robotsTxt = this.robotsTxtHelper.parse(getMethod.getResponseBodyAsStream())) != null && (directives = robotsTxt.getDirectives(this.userAgent)) != null) {
                        for (String urlPattern : directives.getDisallows()) {
                            if (!StringUtil.isNotBlank((String)urlPattern)) continue;
                            urlPattern = this.convertRobotsTxtPathPattern(urlPattern);
                            robotContext.getUrlFilter().addExclude(hostUrl + urlPattern);
                        }
                    }
                }
                Object var16_20 = null;
            }
            catch (RobotSystemException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RobotCrawlAccessException("Could not process " + robotTxtUrl + ". ", e);
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            getMethod.releaseConnection();
            throw throwable;
        }
        getMethod.releaseConnection();
    }

    protected String convertRobotsTxtPathPattern(String path) {
        String newPath = path.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
        if (newPath.charAt(0) != '/') {
            newPath = ".*" + newPath;
        }
        if (!newPath.endsWith("$") && !newPath.endsWith(".*")) {
            newPath = newPath + ".*";
        }
        return newPath.replaceAll("\\.\\*\\.\\*", ".*");
    }

    public ResponseData doGet(String url) {
        GetMethod getMethod;
        try {
            getMethod = new GetMethod(url);
        }
        catch (IllegalArgumentException e) {
            throw new RobotCrawlAccessException("The url may not be valid: " + url, e);
        }
        return this.doHttpMethod(url, (HttpMethod)getMethod);
    }

    public ResponseData doHead(String url) {
        HeadMethod headMethod;
        try {
            headMethod = new HeadMethod(url);
        }
        catch (IllegalArgumentException e) {
            throw new RobotCrawlAccessException("The url may not be valid: " + url, e);
        }
        return this.doHttpMethod(url, (HttpMethod)headMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseData doHttpMethod(String url, HttpMethod httpMethod) {
        block48: {
            if (this.httpClient == null) {
                this.init();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Accessing " + url);
            }
            try {
                this.processRobotsTxt(url);
            }
            catch (RobotCrawlAccessException e) {
                if (logger.isInfoEnabled()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(e.getMessage());
                    if (e.getCause() != null) {
                        buf.append(e.getCause().getMessage());
                    }
                    logger.info(buf.toString());
                }
                if (!logger.isDebugEnabled()) break block48;
                logger.debug("Crawling Access Exception at " + url, (Throwable)e);
            }
        }
        httpMethod.setFollowRedirects(false);
        if (this.cookiePolicy != null) {
            httpMethod.getParams().setCookiePolicy(this.cookiePolicy);
        }
        for (Header header : this.requestHeaderList) {
            httpMethod.setRequestHeader(header);
        }
        ResponseData responseData = null;
        InputStream inputStream = null;
        try {
            ResponseData responseData2;
            try {
                long maxLength;
                int idx;
                this.httpClient.executeMethod(httpMethod);
                int httpStatusCode = httpMethod.getStatusCode();
                if (httpStatusCode >= 300 && httpStatusCode < 400) {
                    Header locationHeader = httpMethod.getResponseHeader("location");
                    if (locationHeader == null) {
                        logger.warn("Invalid redirect location at " + url);
                    } else {
                        responseData = new ResponseData();
                        responseData.setRedirectLocation(locationHeader.getValue());
                        ResponseData responseData3 = responseData;
                        Object var16_17 = null;
                        httpMethod.releaseConnection();
                        return responseData3;
                    }
                }
                long contentLength = 0L;
                InputStream responseBodyStream = httpMethod.getResponseBodyAsStream();
                if (responseBodyStream == null) {
                    inputStream = new ByteArrayInputStream(new byte[0]);
                } else {
                    File outputFile = File.createTempFile("s2robot-CommonsHttpClient-", ".out");
                    DeferredFileOutputStream dfos = null;
                    try {
                        try {
                            dfos = new DeferredFileOutputStream(this.responseBodyInMemoryThresholdSize, outputFile);
                            StreamUtil.drain(httpMethod.getResponseBodyAsStream(), (OutputStream)dfos);
                            dfos.flush();
                            Object var12_23 = null;
                            IOUtils.closeQuietly((OutputStream)dfos);
                        }
                        catch (Throwable throwable) {
                            Object var12_24 = null;
                            IOUtils.closeQuietly((OutputStream)dfos);
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        if (outputFile.delete()) throw e;
                        logger.warn("Could not delete " + outputFile.getAbsolutePath());
                        throw e;
                    }
                    if (dfos.isInMemory()) {
                        inputStream = new ByteArrayInputStream(dfos.getData());
                        contentLength = dfos.getData().length;
                        if (!outputFile.delete()) {
                            logger.warn("Could not delete " + outputFile.getAbsolutePath());
                        }
                    } else {
                        inputStream = new TemporaryFileInputStream(outputFile);
                        contentLength = outputFile.length();
                    }
                }
                String contentType = null;
                Header contentTypeHeader = httpMethod.getResponseHeader("Content-Type");
                if (contentTypeHeader != null && (idx = (contentType = contentTypeHeader.getValue()).indexOf(59)) > 0) {
                    contentType = contentType.substring(0, idx);
                }
                if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength(contentType))) {
                    throw new MaxLengthExceededException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + url);
                }
                responseData = new ResponseData();
                if (httpMethod instanceof HeadMethod) {
                    responseData.setMethod("HEAD");
                } else {
                    responseData.setMethod("GET");
                }
                responseData.setUrl(url);
                if (httpMethod instanceof GetMethod) {
                    responseData.setCharSet(((GetMethod)httpMethod).getResponseCharSet());
                } else {
                    responseData.setCharSet("UTF-8");
                }
                responseData.setResponseBody(inputStream);
                responseData.setHttpStatusCode(httpStatusCode);
                for (Header header : httpMethod.getResponseHeaders()) {
                    responseData.addMetaData(header.getName(), header.getValue());
                }
                if (contentType == null) {
                    responseData.setMimeType(this.defaultMimeType);
                } else {
                    responseData.setMimeType(contentType);
                }
                Header contentLengthHeader = httpMethod.getResponseHeader("Content-Length");
                if (contentLengthHeader == null) {
                    responseData.setContentLength(contentLength);
                } else {
                    String value = contentLengthHeader.getValue();
                    try {
                        responseData.setContentLength(Long.parseLong(value));
                    }
                    catch (Exception e) {
                        responseData.setContentLength(contentLength);
                    }
                }
                Header lastModifiedHeader = httpMethod.getResponseHeader("Last-Modified");
                if (lastModifiedHeader != null) {
                    String value = lastModifiedHeader.getValue();
                    if (StringUtil.isNotBlank((String)value)) {
                        Date d = this.parseLastModified(value);
                        if (d != null) {
                            responseData.setLastModified(d);
                        } else {
                            responseData.setLastModified(new Date());
                        }
                    }
                } else {
                    responseData.setLastModified(new Date());
                }
                responseData2 = responseData;
                Object var16_18 = null;
            }
            catch (UnknownHostException e) {
                IOUtils.closeQuietly(inputStream);
                throw new RobotCrawlAccessException("Unknown host(" + e.getMessage() + "): " + url, e);
            }
            catch (NoRouteToHostException e) {
                IOUtils.closeQuietly(inputStream);
                throw new RobotCrawlAccessException("No route to host(" + e.getMessage() + "): " + url, e);
            }
            catch (ConnectException e) {
                IOUtils.closeQuietly(inputStream);
                throw new RobotCrawlAccessException("Connection time out(" + e.getMessage() + "): " + url, e);
            }
            catch (SocketException e) {
                IOUtils.closeQuietly(inputStream);
                throw new RobotCrawlAccessException("Socket exception(" + e.getMessage() + "): " + url, e);
            }
            catch (IOException e) {
                IOUtils.closeQuietly(inputStream);
                throw new RobotCrawlAccessException("I/O exception(" + e.getMessage() + "): " + url, e);
            }
            catch (RobotSystemException e) {
                IOUtils.closeQuietly(inputStream);
                throw e;
            }
            catch (Exception e) {
                IOUtils.closeQuietly(inputStream);
                throw new RobotSystemException("Failed to access " + url, e);
            }
            httpMethod.releaseConnection();
            return responseData2;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            httpMethod.releaseConnection();
            throw throwable;
        }
    }

    protected Date parseLastModified(String value) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        try {
            return sdf.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

