/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.mail.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mobylet.core.Carrier;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.mail.MailConstants;
import org.mobylet.mail.selector.MailCharsetSelector;
import org.mobylet.mail.util.Base64Utils;
import org.mobylet.mail.util.MailEmojiUtils;

public class MailHeaderUtils
implements MailConstants {
    private static final Pattern PATTERN_ENCODEDHEADER = Pattern.compile("([\\p{Cntrl}]+ )?=\\?[a-zA-Z0-9_-]+\\?B\\?[a-zA-Z0-9/+=\\r\\n]+\\?=");
    private static final Pattern PATTERN_ENCODEDHEADER_CHARSET = Pattern.compile("=\\?[a-zA-Z0-9_-]+\\?");
    private static final Pattern PATTERN_ENCODEDHEADER_BODY = Pattern.compile("\\?B\\?[a-zA-Z0-9/+=\\r\\n]+\\?=");

    public static String encodeHeaderString(Carrier carrier, String srcString) {
        if (StringUtils.isEmpty((String)srcString)) {
            return "";
        }
        boolean isAsciiAll = true;
        for (char c : srcString.toCharArray()) {
            if (c <= '\u00ff') continue;
            isAsciiAll = false;
            break;
        }
        if (isAsciiAll) {
            return srcString;
        }
        MailCharsetSelector charsetSelector = (MailCharsetSelector)SingletonUtils.get(MailCharsetSelector.class);
        Charset encodingCharset = charsetSelector.getEncodingCharset(carrier);
        String notifyCharset = charsetSelector.getNotifyCharset(carrier);
        byte[] encodedBytes = null;
        encodedBytes = MailEmojiUtils.convert(carrier, srcString).getBytes(encodingCharset);
        String base64String = Base64Utils.encode(encodedBytes);
        String base64EncodedString = "=?" + notifyCharset + "?B?" + base64String + "?=";
        base64EncodedString = base64EncodedString.replaceAll("[\\r\\n]", "");
        return base64EncodedString;
    }

    public static String decodeHeaderString(Carrier carrier, String srcString) {
        if (StringUtils.isEmpty((String)srcString)) {
            return "";
        }
        Matcher encodedStringMatcher = PATTERN_ENCODEDHEADER.matcher(srcString);
        StringBuffer sBuf = new StringBuffer();
        StringBuilder repBuf = new StringBuilder();
        Charset charset = null;
        while (encodedStringMatcher.find()) {
            Matcher bodyMatcher;
            String encodedString = encodedStringMatcher.group();
            Matcher charsetMatcher = PATTERN_ENCODEDHEADER_CHARSET.matcher(encodedString);
            if (charsetMatcher.find()) {
                String charsetString = charsetMatcher.group();
                charset = Charset.forName(charsetString = charsetString.substring(2, charsetString.length() - 1));
                if (charset.contains(Charset.forName("ISO-2022-JP"))) {
                    charset = Charset.forName("X-WINDOWS-ISO2022JP");
                }
            }
            if (!(bodyMatcher = PATTERN_ENCODEDHEADER_BODY.matcher(encodedString)).find()) continue;
            String bodyString = bodyMatcher.group();
            bodyString = bodyString.substring(3, bodyString.length() - 2);
            byte[] decodedBodyBytes = Base64Utils.decode(bodyString);
            String decodedBodyString = null;
            try {
                decodedBodyString = new String(decodedBodyBytes, charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new MobyletRuntimeException("\u6587\u5b57\u30b3\u30fc\u30c9\u5909\u63db\u306b\u5931\u6557 charset = " + charset, (Exception)e);
            }
            encodedStringMatcher.appendReplacement(sBuf, decodedBodyString);
            String trimString = sBuf.toString().trim();
            repBuf.append(trimString);
            sBuf.delete(0, sBuf.length());
        }
        encodedStringMatcher.appendTail(sBuf);
        String trimString = sBuf.toString().trim();
        repBuf.append(trimString);
        return repBuf.toString().trim();
    }
}

