/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.LongCharProcedure;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractLongCharMap
extends AbstractSet {
    public boolean containsKey(final long key) {
        return !this.forEachKey(new LongProcedure(){

            public boolean apply(long iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final char value) {
        return !this.forEachPair(new LongCharProcedure(){

            public boolean apply(long iterKey, char iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractLongCharMap copy() {
        return (AbstractLongCharMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractLongCharMap)) {
            return false;
        }
        final AbstractLongCharMap other = (AbstractLongCharMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new LongCharProcedure(){

            public boolean apply(long key, char value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new LongCharProcedure(){

            public boolean apply(long key, char value) {
                return AbstractLongCharMap.this.containsKey(key) && AbstractLongCharMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public boolean forEachPair(final LongCharProcedure procedure) {
        return this.forEachKey(new LongProcedure(){

            public boolean apply(long key) {
                return procedure.apply(key, AbstractLongCharMap.this.get(key));
            }
        });
    }

    public abstract char get(long var1);

    public LongArrayList keys() {
        LongArrayList list = new LongArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final LongArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(LongArrayList keyList) {
        this.pairsSortedByValue(keyList, new CharArrayList(this.size()));
    }

    public void pairsMatching(final LongCharProcedure condition, final LongArrayList keyList, final CharArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new LongCharProcedure(){

            public boolean apply(long key, char value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(LongArrayList keyList, CharArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(LongArrayList keyList, CharArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final long[] k = keyList.elements();
        final char[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                char t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                long t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(long var1, char var3);

    public abstract boolean removeKey(long var1);

    public String toString() {
        LongArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        LongArrayList theKeys = new LongArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public CharArrayList values() {
        CharArrayList list = new CharArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final CharArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long key) {
                list.add(AbstractLongCharMap.this.get(key));
                return true;
            }
        });
    }

    public char adjustOrPutValue(long key, char newValue, char incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (char)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

