/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.FloatObjectProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.set.AbstractSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloatObjectMap<T>
extends AbstractSet {
    public boolean containsKey(final float key) {
        return !this.forEachKey(new FloatProcedure(){

            public boolean apply(float iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final T value) {
        return !this.forEachPair(new FloatObjectProcedure<T>(){

            @Override
            public boolean apply(float iterKey, Object iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractFloatObjectMap<T> copy() {
        return (AbstractFloatObjectMap)this.getClass().cast(this.clone());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractFloatObjectMap)) {
            return false;
        }
        final AbstractFloatObjectMap other = (AbstractFloatObjectMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new FloatObjectProcedure(){

            public boolean apply(float key, Object value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new FloatObjectProcedure(){

            public boolean apply(float key, Object value) {
                return AbstractFloatObjectMap.this.containsKey(key) && AbstractFloatObjectMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(FloatProcedure var1);

    public boolean forEachPair(final FloatObjectProcedure<T> procedure) {
        return this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                return procedure.apply(key, AbstractFloatObjectMap.this.get(key));
            }
        });
    }

    public abstract T get(float var1);

    public FloatArrayList keys() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(FloatArrayList keyList) {
        this.pairsSortedByValue(keyList, new ArrayList(this.size()));
    }

    public void pairsMatching(final FloatObjectProcedure<T> condition, final FloatArrayList keyList, final List<T> valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new FloatObjectProcedure<T>(){

            @Override
            public boolean apply(float key, T value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(FloatArrayList keyList, List<T> valueList) {
        this.keys(keyList);
        keyList.sort();
        Object[] tempValueList = new Object[keyList.size()];
        int i = keyList.size();
        while (--i >= 0) {
            tempValueList[i] = this.get(keyList.getQuick(i));
        }
        valueList.clear();
        for (Object value : tempValueList) {
            valueList.add(value);
        }
    }

    public void pairsSortedByValue(FloatArrayList keyList, List<T> valueList) {
        this.keys(keyList);
        this.values(valueList);
        if (!valueList.isEmpty() && !(valueList.get(0) instanceof Comparable)) {
            throw new UnsupportedOperationException("Cannot sort the values; " + valueList.get(0).getClass() + " does not implement Comparable");
        }
        final float[] k = keyList.elements();
        final List<T> valueRef = valueList;
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                Object t1 = valueRef.get(a);
                valueRef.set(a, valueRef.get(b));
                valueRef.set(b, t1);
                float t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                int ab = ((Comparable)valueRef.get(a)).compareTo(valueRef.get(b));
                return ab < 0 ? -1 : (ab > 0 ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(float var1, T var2);

    public abstract boolean removeKey(float var1);

    public String toString() {
        FloatArrayList theKeys = this.keys();
        theKeys.sort();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        FloatArrayList theKeys = new FloatArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public List<T> values() {
        ArrayList list = new ArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final List<T> list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                list.add(AbstractFloatObjectMap.this.get(key));
                return true;
            }
        });
    }
}

