/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import com.ibm.icu.text.FilteredNormalizer2;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UnicodeSet;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUNormalizer2Filter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.MultiTermAwareComponent;
import org.apache.solr.common.SolrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICUNormalizer2FilterFactory
extends BaseTokenFilterFactory
implements MultiTermAwareComponent {
    private Normalizer2 normalizer;

    public void init(Map<String, String> args) {
        UnicodeSet set;
        String mode;
        super.init(args);
        String name = args.get("name");
        if (name == null) {
            name = "nfkc_cf";
        }
        if ((mode = args.get("mode")) == null) {
            mode = "compose";
        }
        if (mode.equals("compose")) {
            this.normalizer = Normalizer2.getInstance(null, (String)name, (Normalizer2.Mode)Normalizer2.Mode.COMPOSE);
        } else if (mode.equals("decompose")) {
            this.normalizer = Normalizer2.getInstance(null, (String)name, (Normalizer2.Mode)Normalizer2.Mode.DECOMPOSE);
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid mode: " + mode);
        }
        String filter = args.get("filter");
        if (filter != null && !(set = new UnicodeSet(filter)).isEmpty()) {
            set.freeze();
            this.normalizer = new FilteredNormalizer2(this.normalizer, set);
        }
    }

    public TokenStream create(TokenStream input) {
        return new ICUNormalizer2Filter(input, this.normalizer);
    }

    public Object getMultiTermComponent() {
        return this;
    }
}

