/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaDataFactory;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyTypeFactory;
import org.seasar.dbflute.s2dao.metadata.impl.TnRelationPropertyTypeImpl;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnRelationPropertyTypeFactoryImpl
implements TnRelationPropertyTypeFactory {
    protected Class<?> _beanClass;
    protected TnBeanAnnotationReader _beanAnnotationReader;
    protected TnBeanMetaDataFactory _beanMetaDataFactory;
    protected DatabaseMetaData _databaseMetaData;
    protected int _relationNestLevel;
    protected boolean _stopRelationCreation;

    public TnRelationPropertyTypeFactoryImpl(Class<?> beanClass, TnBeanAnnotationReader beanAnnotationReader, TnBeanMetaDataFactory beanMetaDataFactory, DatabaseMetaData databaseMetaData, int relationNestLevel, boolean stopRelationCreation) {
        this._beanClass = beanClass;
        this._beanAnnotationReader = beanAnnotationReader;
        this._beanMetaDataFactory = beanMetaDataFactory;
        this._databaseMetaData = databaseMetaData;
        this._relationNestLevel = relationNestLevel;
        this._stopRelationCreation = stopRelationCreation;
    }

    @Override
    public TnRelationPropertyType[] createRelationPropertyTypes() {
        ArrayList<TnRelationPropertyType> list = new ArrayList<TnRelationPropertyType>();
        DfBeanDesc beanDesc = this.getBeanDesc();
        List<String> proppertyNameList = beanDesc.getProppertyNameList();
        for (String proppertyName : proppertyNameList) {
            DfPropertyDesc pd = beanDesc.getPropertyDesc(proppertyName);
            if (this._stopRelationCreation || !this.isRelationProperty(pd)) continue;
            TnRelationPropertyType rpt = this.createRelationPropertyType(pd);
            list.add(rpt);
        }
        return list.toArray(new TnRelationPropertyType[list.size()]);
    }

    protected TnRelationPropertyType createRelationPropertyType(DfPropertyDesc propertyDesc) {
        String[] yourKeys;
        String[] myKeys;
        int relno = this._beanAnnotationReader.getRelationNo(propertyDesc);
        String relkeys = this._beanAnnotationReader.getRelationKey(propertyDesc);
        if (relkeys != null) {
            ArrayList myKeyList = DfCollectionUtil.newArrayList();
            ArrayList yourKeyList = DfCollectionUtil.newArrayList();
            List<String> tokenList = Srl.splitListTrimmed(relkeys, ",");
            for (String token : tokenList) {
                int index = token.indexOf(58);
                if (index > 0) {
                    myKeyList.add(token.substring(0, index));
                    yourKeyList.add(token.substring(index + 1));
                    continue;
                }
                myKeyList.add(token);
                yourKeyList.add(token);
            }
            myKeys = myKeyList.toArray(new String[myKeyList.size()]);
            yourKeys = yourKeyList.toArray(new String[yourKeyList.size()]);
        } else {
            myKeys = new String[]{};
            yourKeys = new String[]{};
        }
        TnBeanMetaData beanMetaData = this.createRelationBeanMetaData(propertyDesc.getPropertyType());
        DfPropertyDesc pd = propertyDesc;
        TnRelationPropertyTypeImpl rpt = new TnRelationPropertyTypeImpl(pd, relno, myKeys, yourKeys, beanMetaData);
        return rpt;
    }

    protected TnBeanMetaData createRelationBeanMetaData(Class<?> relationBeanClass) {
        return this._beanMetaDataFactory.createBeanMetaData(this._databaseMetaData, relationBeanClass, this._relationNestLevel + 1);
    }

    protected boolean isRelationProperty(DfPropertyDesc propertyDesc) {
        return this._beanAnnotationReader.hasRelationNo(propertyDesc);
    }

    protected DfBeanDesc getBeanDesc() {
        return DfBeanDescFactory.getBeanDesc(this._beanClass);
    }
}

