/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.seasar.dbflute.s2dao.metadata.TnProcedureParameterType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnProcedureMetaData {
    private final String _procedureName;
    private final Map<String, TnProcedureParameterType> _parameterTypeMap = this.createParameterTypeMap();
    private final SortedSet<TnProcedureParameterType> _parameterTypeSortedSet = this.createParameterTypeSet();
    private List<TnProcedureParameterType> _bindParameterTypeList;
    private List<TnProcedureParameterType> _notParamResultTypeList;
    private TnProcedureParameterType _returnParameterType;
    private boolean _fixed;

    protected Map<String, TnProcedureParameterType> createParameterTypeMap() {
        return new HashMap<String, TnProcedureParameterType>();
    }

    protected SortedSet<TnProcedureParameterType> createParameterTypeSet() {
        return new TreeSet<TnProcedureParameterType>(new Comparator<TnProcedureParameterType>(){

            @Override
            public int compare(TnProcedureParameterType o1, TnProcedureParameterType o2) {
                return o1.getParameterOrder().compareTo(o2.getParameterOrder());
            }
        });
    }

    public TnProcedureMetaData(String procedureName) {
        this._procedureName = procedureName;
    }

    public String createSql() {
        int argSize;
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int bindSize = this.getBindParameterTypeList().size();
        if (this.hasReturnParameterType()) {
            sb.append("? = ");
            argSize = bindSize - 1;
        } else {
            argSize = bindSize;
        }
        sb.append("call ").append(this.getProcedureName()).append("(");
        for (int i = 0; i < argSize; ++i) {
            sb.append("?, ");
        }
        if (argSize > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")}");
        return sb.toString();
    }

    public void fix() {
        this._fixed = true;
        this.getBindParameterTypeList();
        this.getNotParamResultTypeList();
    }

    public String getProcedureName() {
        return this._procedureName;
    }

    private SortedSet<TnProcedureParameterType> getParameterTypeSortedSet() {
        return this._parameterTypeSortedSet;
    }

    public List<TnProcedureParameterType> getBindParameterTypeList() {
        if (this._bindParameterTypeList != null) {
            return this._bindParameterTypeList;
        }
        SortedSet<TnProcedureParameterType> parameterTypeSortedSet = this.getParameterTypeSortedSet();
        ArrayList<TnProcedureParameterType> bindList = new ArrayList<TnProcedureParameterType>();
        for (TnProcedureParameterType ppt : parameterTypeSortedSet) {
            if (ppt.isNotParamResultType()) continue;
            bindList.add(ppt);
        }
        this._bindParameterTypeList = bindList;
        return bindList;
    }

    public List<TnProcedureParameterType> getNotParamResultTypeList() {
        if (this._notParamResultTypeList != null) {
            return this._notParamResultTypeList;
        }
        SortedSet<TnProcedureParameterType> parameterTypeSortedSet = this.getParameterTypeSortedSet();
        ArrayList<TnProcedureParameterType> resultList = new ArrayList<TnProcedureParameterType>();
        for (TnProcedureParameterType ppt : parameterTypeSortedSet) {
            if (!ppt.isNotParamResultType()) continue;
            resultList.add(ppt);
        }
        this._notParamResultTypeList = resultList;
        return resultList;
    }

    public boolean hasReturnParameterType() {
        return this._returnParameterType != null;
    }

    public TnProcedureParameterType getReturnParameterType() {
        return this._returnParameterType;
    }

    public void addParameterType(TnProcedureParameterType parameterType) {
        if (parameterType == null) {
            String msg = "The argument 'parameterType' should not be null!";
            throw new IllegalStateException(msg);
        }
        if (this._fixed) {
            String msg = "This object has already been fixed:";
            msg = msg + " added=" + parameterType.getParameterName();
            throw new IllegalStateException(msg);
        }
        String name = parameterType.getParameterName();
        this._parameterTypeMap.put(name, parameterType);
        this._parameterTypeSortedSet.add(parameterType);
        if (parameterType.isReturnType()) {
            this._returnParameterType = parameterType;
        }
    }
}

