/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.outsidesql.executor;

import java.util.List;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.dbflute.bhv.core.command.AbstractOutsideSqlCommand;
import org.seasar.dbflute.bhv.core.command.OutsideSqlCallCommand;
import org.seasar.dbflute.bhv.core.command.OutsideSqlExecuteCommand;
import org.seasar.dbflute.bhv.core.command.OutsideSqlSelectListCommand;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.exception.FetchingOverSafetySizeException;
import org.seasar.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.seasar.dbflute.jdbc.FetchBean;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.outsidesql.OutsideSqlFilter;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.outsidesql.ProcedurePmb;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlAutoPagingExecutor;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlCursorExecutor;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlEntityExecutor;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlManualPagingExecutor;
import org.seasar.dbflute.outsidesql.factory.OutsideSqlContextFactory;
import org.seasar.dbflute.outsidesql.factory.OutsideSqlExecutorFactory;
import org.seasar.dbflute.outsidesql.typed.ExecuteHandlingPmb;
import org.seasar.dbflute.outsidesql.typed.ListHandlingPmb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlBasicExecutor<BEHAVIOR> {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final String _tableDbName;
    protected final DBDef _currentDBDef;
    protected final StatementConfig _defaultStatementConfig;
    protected final OutsideSqlOption _outsideSqlOption;
    protected final OutsideSqlContextFactory _outsideSqlContextFactory;
    protected final OutsideSqlFilter _outsideSqlFilter;
    protected final OutsideSqlExecutorFactory _outsideSqlExecutorFactory;
    protected boolean _removeBlockComment;
    protected boolean _removeLineComment;
    protected boolean _formatSql;
    protected StatementConfig _statementConfig;

    public OutsideSqlBasicExecutor(BehaviorCommandInvoker behaviorCommandInvoker, String tableDbName, DBDef currentDBDef, StatementConfig defaultStatementConfig, OutsideSqlOption outsideSqlOption, OutsideSqlContextFactory outsideSqlContextFactory, OutsideSqlFilter outsideSqlFilter, OutsideSqlExecutorFactory outsideSqlExecutorFactory) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
        this._defaultStatementConfig = defaultStatementConfig;
        if (outsideSqlOption != null) {
            this._outsideSqlOption = outsideSqlOption;
        } else {
            this._outsideSqlOption = new OutsideSqlOption();
            this._outsideSqlOption.setTableDbName(tableDbName);
        }
        this._outsideSqlContextFactory = outsideSqlContextFactory;
        this._outsideSqlFilter = outsideSqlFilter;
        this._outsideSqlExecutorFactory = outsideSqlExecutorFactory;
    }

    public <ENTITY> ListResultBean<ENTITY> selectList(ListHandlingPmb<BEHAVIOR, ENTITY> pmb) {
        if (pmb == null) {
            String msg = "The argument 'pmb' (typed parameter-bean) should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return this.doSelectList(pmb.getOutsideSqlPath(), pmb, pmb.getEntityType());
    }

    public <ENTITY> ListResultBean<ENTITY> selectList(String path, Object pmb, Class<ENTITY> entityType) {
        return this.doSelectList(path, pmb, entityType);
    }

    protected <ENTITY> ListResultBean<ENTITY> doSelectList(String path, Object pmb, Class<ENTITY> entityType) {
        if (path == null) {
            String msg = "The argument 'path' of outside-SQL should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (entityType == null) {
            String msg = "The argument 'entityType' for result should not be null: path=" + path;
            throw new IllegalArgumentException(msg);
        }
        try {
            List<ENTITY> resultList = this.invoke(this.createSelectListCommand(path, pmb, entityType));
            return this.createListResultBean(resultList);
        }
        catch (FetchingOverSafetySizeException e) {
            this.throwDangerousResultSizeException(pmb, e);
            return null;
        }
    }

    protected <ENTITY> ListResultBean<ENTITY> createListResultBean(List<ENTITY> selectedList) {
        return new ResultBeanBuilder<ENTITY>(this._tableDbName).buildListResultBean(selectedList);
    }

    protected void throwDangerousResultSizeException(Object pmb, FetchingOverSafetySizeException e) {
        if (!(pmb instanceof FetchBean)) {
            String msg = "The exception should be thrown only when the parameter-bean is instance of fetch-bean:";
            msg = msg + " pmb=" + (pmb != null ? pmb.getClass().getName() : null);
            throw new IllegalStateException(msg, e);
        }
        this.createBhvExThrower().throwDangerousResultSizeException((FetchBean)pmb, e);
    }

    public int execute(ExecuteHandlingPmb<BEHAVIOR> pmb) {
        if (pmb == null) {
            String msg = "The argument 'pmb' (typed parameter-bean) should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return this.doExecute(pmb.getOutsideSqlPath(), pmb);
    }

    public int execute(String path, Object pmb) {
        return this.doExecute(path, pmb);
    }

    protected int doExecute(String path, Object pmb) {
        if (path == null) {
            String msg = "The argument 'path' of outside-SQL should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return this.invoke(this.createExecuteCommand(path, pmb));
    }

    public void call(ProcedurePmb pmb) {
        if (pmb == null) {
            throw new IllegalArgumentException("The argument 'pmb' of procedure should not be null.");
        }
        try {
            this.invoke(this.createCallCommand(pmb.getProcedureName(), pmb));
        }
        catch (FetchingOverSafetySizeException e) {
            this.throwDangerousResultSizeException(pmb, e);
        }
    }

    protected <ENTITY> BehaviorCommand<List<ENTITY>> createSelectListCommand(String path, Object pmb, Class<ENTITY> entityType) {
        OutsideSqlSelectListCommand<ENTITY> newed = this.newOutsideSqlSelectListCommand();
        OutsideSqlSelectListCommand<ENTITY> cmd = this.xsetupCommand(newed, path, pmb);
        cmd.setEntityType(entityType);
        return cmd;
    }

    protected <ENTITY> OutsideSqlSelectListCommand<ENTITY> newOutsideSqlSelectListCommand() {
        return new OutsideSqlSelectListCommand();
    }

    protected BehaviorCommand<Integer> createExecuteCommand(String path, Object pmb) {
        return this.xsetupCommand(this.newOutsideSqlExecuteCommand(), path, pmb);
    }

    protected OutsideSqlExecuteCommand newOutsideSqlExecuteCommand() {
        return new OutsideSqlExecuteCommand();
    }

    protected BehaviorCommand<Void> createCallCommand(String path, Object pmb) {
        return this.xsetupCommand(this.newOutsideSqlCallCommand(), path, pmb);
    }

    protected OutsideSqlCallCommand newOutsideSqlCallCommand() {
        return new OutsideSqlCallCommand();
    }

    protected <COMMAND extends AbstractOutsideSqlCommand<?>> COMMAND xsetupCommand(COMMAND cmd, String path, Object pmb) {
        cmd.setTableDbName(this._tableDbName);
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setOutsideSqlPath(path);
        cmd.setParameterBean(pmb);
        cmd.setOutsideSqlOption(this._outsideSqlOption);
        cmd.setCurrentDBDef(this._currentDBDef);
        cmd.setOutsideSqlContextFactory(this._outsideSqlContextFactory);
        cmd.setOutsideSqlFilter(this._outsideSqlFilter);
        return cmd;
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    public OutsideSqlEntityExecutor<BEHAVIOR> entityHandling() {
        return this.createOutsideSqlEntityExecutor();
    }

    protected OutsideSqlEntityExecutor<BEHAVIOR> createOutsideSqlEntityExecutor() {
        return this._outsideSqlExecutorFactory.createEntity(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, this._outsideSqlOption);
    }

    public OutsideSqlManualPagingExecutor<BEHAVIOR> manualPaging() {
        this._outsideSqlOption.manualPaging();
        return this.createOutsideSqlManualPagingExecutor();
    }

    protected OutsideSqlManualPagingExecutor<BEHAVIOR> createOutsideSqlManualPagingExecutor() {
        return this._outsideSqlExecutorFactory.createManualPaging(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, this._outsideSqlOption);
    }

    public OutsideSqlAutoPagingExecutor<BEHAVIOR> autoPaging() {
        this._outsideSqlOption.autoPaging();
        return this.createOutsideSqlAutoPagingExecutor();
    }

    protected OutsideSqlAutoPagingExecutor<BEHAVIOR> createOutsideSqlAutoPagingExecutor() {
        return this._outsideSqlExecutorFactory.createAutoPaging(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, this._outsideSqlOption);
    }

    public OutsideSqlCursorExecutor<BEHAVIOR> cursorHandling() {
        return this.createOutsideSqlCursorExecutor();
    }

    protected OutsideSqlCursorExecutor<BEHAVIOR> createOutsideSqlCursorExecutor() {
        return this._outsideSqlExecutorFactory.createCursor(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._outsideSqlOption);
    }

    public OutsideSqlBasicExecutor<BEHAVIOR> removeBlockComment() {
        this._outsideSqlOption.removeBlockComment();
        return this;
    }

    public OutsideSqlBasicExecutor<BEHAVIOR> removeLineComment() {
        this._outsideSqlOption.removeLineComment();
        return this;
    }

    public OutsideSqlBasicExecutor<BEHAVIOR> formatSql() {
        this._outsideSqlOption.formatSql();
        return this;
    }

    public OutsideSqlBasicExecutor<BEHAVIOR> configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        return this._behaviorCommandInvoker.createBehaviorExceptionThrower();
    }
}

