/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.coption;

import java.util.List;
import org.seasar.dbflute.cbean.coption.SimpleStringOption;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.seasar.dbflute.dbway.ExtensionOperand;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LikeSearchOption
extends SimpleStringOption {
    private static final long serialVersionUID = 1L;
    protected static final String LIKE_PREFIX = "prefix";
    protected static final String LIKE_SUFFIX = "suffix";
    protected static final String LIKE_CONTAIN = "contain";
    protected String _like;
    protected String _escape;
    protected boolean _asOrSplit;
    protected List<String> _originalWildCardList;

    @Override
    public String getRearOption() {
        if (this._escape == null || this._escape.trim().length() == 0) {
            return "";
        }
        return " escape '" + this._escape + "'";
    }

    public LikeSearchOption likePrefix() {
        this._like = LIKE_PREFIX;
        this.doLikeAutoEscape();
        return this;
    }

    public LikeSearchOption likeSuffix() {
        this._like = LIKE_SUFFIX;
        this.doLikeAutoEscape();
        return this;
    }

    public LikeSearchOption likeContain() {
        this._like = LIKE_CONTAIN;
        this.doLikeAutoEscape();
        return this;
    }

    protected void doLikeAutoEscape() {
        this.escape();
    }

    public LikeSearchOption escape() {
        return this.escapeByPipeLine();
    }

    public LikeSearchOption escapeByPipeLine() {
        this._escape = "|";
        return this;
    }

    public LikeSearchOption escapeByAtMark() {
        this._escape = "@";
        return this;
    }

    public LikeSearchOption escapeBySlash() {
        this._escape = "/";
        return this;
    }

    public LikeSearchOption escapeByBackSlash() {
        this._escape = "\\";
        return this;
    }

    public LikeSearchOption notEscape() {
        this._escape = null;
        return this;
    }

    public LikeSearchOption splitByBlank() {
        return (LikeSearchOption)this.doSplitByBlank();
    }

    public LikeSearchOption splitByBlank(int splitLimitCount) {
        return (LikeSearchOption)this.doSplitByBlank(splitLimitCount);
    }

    public LikeSearchOption splitBySpace() {
        return (LikeSearchOption)this.doSplitBySpace();
    }

    public LikeSearchOption splitBySpace(int splitLimitCount) {
        return (LikeSearchOption)this.doSplitBySpace(splitLimitCount);
    }

    public LikeSearchOption splitBySpaceContainsDoubleByte() {
        return (LikeSearchOption)this.doSplitBySpaceContainsDoubleByte();
    }

    public LikeSearchOption splitBySpaceContainsDoubleByte(int splitLimitCount) {
        return (LikeSearchOption)this.doSplitBySpaceContainsDoubleByte(splitLimitCount);
    }

    public LikeSearchOption splitByPipeLine() {
        return (LikeSearchOption)this.doSplitByPipeLine();
    }

    public LikeSearchOption splitByPipeLine(int splitLimitCount) {
        return (LikeSearchOption)this.doSplitByPipeLine(splitLimitCount);
    }

    public LikeSearchOption splitByVarious(List<String> delimiterList) {
        return (LikeSearchOption)this.doSplitByVarious(delimiterList);
    }

    public LikeSearchOption splitByVarious(List<String> delimiterList, int splitLimitCount) {
        return (LikeSearchOption)this.doSplitByVarious(delimiterList, splitLimitCount);
    }

    public LikeSearchOption asOrSplit() {
        this._asOrSplit = true;
        return this;
    }

    public boolean isAsOrSplit() {
        return this._asOrSplit;
    }

    @Override
    public String generateRealValue(String value) {
        value = super.generateRealValue(value);
        if (this._escape != null && this._escape.trim().length() != 0) {
            String tmp = this.replace(value, this._escape, this._escape + this._escape);
            tmp = this.filterEscape(tmp, "%");
            tmp = this.filterEscape(tmp, "_");
            if (this._originalWildCardList != null) {
                for (String wildCard : this._originalWildCardList) {
                    tmp = this.filterEscape(tmp, wildCard);
                }
            }
            value = tmp;
        }
        String wildCard = "%";
        if (this._like == null || this._like.trim().length() == 0) {
            return value;
        }
        if (this._like.equals(LIKE_PREFIX)) {
            return value + "%";
        }
        if (this._like.equals(LIKE_SUFFIX)) {
            return "%" + value;
        }
        if (this._like.equals(LIKE_CONTAIN)) {
            return "%" + value + "%";
        }
        String msg = "The like was wrong string: " + this._like;
        throw new IllegalStateException(msg);
    }

    protected String filterEscape(String target, String wildCard) {
        return this.replace(target, wildCard, this._escape + wildCard);
    }

    public LikeSearchOption acceptOriginalWildCardList(List<String> originalWildCardList) {
        this._originalWildCardList = originalWildCardList;
        return this;
    }

    @Override
    protected SimpleStringOption newDeepCopyInstance() {
        return new LikeSearchOption();
    }

    public ExtensionOperand getExtensionOperand() {
        return null;
    }

    public QueryClauseArranger getWhereClauseArranger() {
        return null;
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        String split = this.isSplit() ? (this._asOrSplit ? "true(or)" : "true(and)") : "false";
        return title + ":{like=" + this._like + ", escape=" + this._escape + ", split=" + split + "}";
    }
}

