/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.chelper;

import java.util.List;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.cbean.chelper.HpCalcStatement;
import org.seasar.dbflute.cbean.chelper.HpCalculator;
import org.seasar.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.dbflute.cbean.coption.ColumnConversionOption;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HpCalcSpecification<CB extends ConditionBean>
implements HpCalculator,
HpCalcStatement {
    protected final SpecifyQuery<CB> _specifyQuery;
    protected ConditionBean _baseCB;
    protected CB _specifedCB;
    protected final List<HpCalculator.CalculationElement> _calculationList = DfCollectionUtil.newArrayList();
    protected boolean _leftMode;
    protected HpCalcSpecification<CB> _leftCalcSp;
    protected boolean _convert;

    public HpCalcSpecification(SpecifyQuery<CB> specifyQuery) {
        this._specifyQuery = specifyQuery;
    }

    public HpCalcSpecification(SpecifyQuery<CB> specifyQuery, ConditionBean baseCB) {
        this._specifyQuery = specifyQuery;
        this._baseCB = baseCB;
    }

    public void specify(CB cb) {
        this._specifyQuery.specify(cb);
        this._specifedCB = cb;
        if (this._baseCB == null) {
            this._baseCB = cb;
        }
    }

    public ColumnInfo getSpecifiedColumnInfo() {
        return this._specifedCB.getSqlClause().getSpecifiedColumnInfoAsOne();
    }

    public ColumnInfo getSpecifiedDerivingColumnInfo() {
        return this._specifedCB.getSqlClause().getSpecifiedDerivingColumnInfoAsOne();
    }

    public ColumnInfo getResolvedSpecifiedColumnInfo() {
        ColumnInfo columnInfo = this.getSpecifiedColumnInfo();
        return columnInfo != null ? columnInfo : this.getSpecifiedDerivingColumnInfo();
    }

    public ColumnRealName getResolvedSpecifiedColumnRealName() {
        ColumnRealName columnRealName = this._specifedCB.getSqlClause().getSpecifiedColumnRealNameAsOne();
        if (columnRealName != null) {
            return columnRealName;
        }
        String subQuery = this._specifedCB.getSqlClause().getSpecifiedDerivingSubQueryAsOne();
        if (subQuery != null) {
            return new ColumnRealName(null, new ColumnSqlName(subQuery));
        }
        return null;
    }

    public ColumnSqlName getResolvedSpecifiedColumnSqlName() {
        ColumnSqlName columnSqlName = this._specifedCB.getSqlClause().getSpecifiedColumnSqlNameAsOne();
        if (columnSqlName != null) {
            return columnSqlName;
        }
        String subQuery = this._specifedCB.getSqlClause().getSpecifiedDerivingSubQueryAsOne();
        if (subQuery != null) {
            return new ColumnSqlName(subQuery);
        }
        return null;
    }

    public String getResolvedSpecifiedTableAliasName() {
        ColumnRealName columnRealName = this._specifedCB.getSqlClause().getSpecifiedColumnRealNameAsOne();
        if (columnRealName != null) {
            return columnRealName.getTableAliasName();
        }
        return this._specifedCB.getSqlClause().getSpecifiedDerivingAliasNameAsOne();
    }

    @Override
    public HpCalculator plus(Number plusValue) {
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.plus(plusValue);
            return this;
        }
        return this.register(HpCalculator.CalculationType.PLUS, plusValue);
    }

    @Override
    public HpCalculator minus(Number minusValue) {
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.minus(minusValue);
            return this;
        }
        return this.register(HpCalculator.CalculationType.MINUS, minusValue);
    }

    @Override
    public HpCalculator multiply(Number multiplyValue) {
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.multiply(multiplyValue);
            return this;
        }
        return this.register(HpCalculator.CalculationType.MULTIPLY, multiplyValue);
    }

    @Override
    public HpCalculator divide(Number divideValue) {
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.divide(divideValue);
            return this;
        }
        return this.register(HpCalculator.CalculationType.DIVIDE, divideValue);
    }

    protected HpCalculator register(HpCalculator.CalculationType type, Number value) {
        if (value == null) {
            String msg = "The null value was specified as " + (Object)((Object)type) + ": " + this._specifyQuery;
            throw new IllegalArgumentException(msg);
        }
        HpCalculator.CalculationElement calculation = new HpCalculator.CalculationElement();
        calculation.setCalculationType(type);
        calculation.setCalculationValue(value);
        this._calculationList.add(calculation);
        return this;
    }

    @Override
    public HpCalculator convert(ColumnConversionOption option) {
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.convert(option);
            return this;
        }
        return this.registerConv(option);
    }

    protected HpCalculator registerConv(ColumnConversionOption option) {
        if (option == null) {
            String msg = "The null value was specified as conversion option: " + this._specifyQuery;
            throw new IllegalArgumentException(msg);
        }
        HpCalculator.CalculationElement calculation = new HpCalculator.CalculationElement();
        calculation.setCalculationType(HpCalculator.CalculationType.CONV);
        calculation.setColumnConversionOption(option);
        this._calculationList.add(calculation);
        this.prepareConvOption(option);
        this._convert = true;
        return this;
    }

    protected void prepareConvOption(ColumnConversionOption option) {
        option.xjudgeDatabase(this._baseCB.getSqlClause());
        option.xsetTargetColumnInfo(this.getResolvedSpecifiedColumnInfo());
        this._baseCB.localCQ().xregisterParameterOption(option);
    }

    protected void assertLeftCalcSp() {
        if (this._leftCalcSp == null) {
            this.throwCalculationLeftColumnUnsupportedException();
        }
    }

    protected void throwCalculationLeftColumnUnsupportedException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The calculation for left column is unsupported at the function.");
        br.addItem("Advice");
        br.addElement("For example, ColumnQuery supports it);");
        br.addElement("but UpdateOption does not.");
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    @Override
    public HpCalculator left() {
        this._leftMode = true;
        return this;
    }

    @Override
    public HpCalculator right() {
        this._leftMode = false;
        return this;
    }

    @Override
    public String buildStatementAsSqlName() {
        ColumnSqlName columnSqlName = this.getResolvedSpecifiedColumnSqlName();
        String columnExp = columnSqlName.toString();
        return this.doBuildStatement(columnExp);
    }

    @Override
    public String buildStatementToSpecifidName(String columnExp) {
        return this.doBuildStatement(columnExp);
    }

    protected String doBuildStatement(String columnExp) {
        List<HpCalculator.CalculationElement> calculationList = this.getCalculationList();
        if (calculationList.isEmpty()) {
            return null;
        }
        String targetExp = this.decryptIfNeeds(columnExp);
        int index = 0;
        for (HpCalculator.CalculationElement calculation : calculationList) {
            if (index > 0) {
                targetExp = "(" + targetExp + ")";
            }
            targetExp = calculation.buildExp(targetExp);
            ++index;
        }
        return targetExp;
    }

    protected String decryptIfNeeds(String valueExp) {
        ColumnInfo columnInfo = this.getSpecifiedColumnInfo();
        if (columnInfo == null) {
            return valueExp;
        }
        ColumnFunctionCipher cipher = this._specifedCB.getSqlClause().findColumnFunctionCipher(columnInfo);
        return cipher != null ? cipher.decrypt(valueExp) : valueExp;
    }

    public boolean isSpecifyColumn() {
        return this.getSpecifiedColumnInfo() != null;
    }

    public boolean isDerivedReferrer() {
        return this.getSpecifiedDerivingColumnInfo() != null;
    }

    public boolean mayNullRevived() {
        if (this.isDerivedReferrer()) {
            return true;
        }
        for (HpCalculator.CalculationElement calculationElement : this._calculationList) {
            ColumnConversionOption option = calculationElement.getColumnConversionOption();
            if (option == null || !option.mayNullRevived()) continue;
            return true;
        }
        return false;
    }

    public SpecifyQuery<CB> getSpecifyQuery() {
        return this._specifyQuery;
    }

    public List<HpCalculator.CalculationElement> getCalculationList() {
        return this._calculationList;
    }

    public boolean hasConvert() {
        return this._convert;
    }

    public HpCalcSpecification<CB> getLeftCalcSp() {
        return this._leftCalcSp;
    }

    public void setLeftCalcSp(HpCalcSpecification<CB> leftCalcSp) {
        this._leftCalcSp = leftCalcSp;
    }
}

