/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.BehaviorSelector;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.BehaviorReadable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.dbflute.bhv.core.command.AbstractBehaviorCommand;
import org.seasar.dbflute.bhv.core.command.AbstractEntityCommand;
import org.seasar.dbflute.bhv.core.command.InsertEntityCommand;
import org.seasar.dbflute.bhv.core.command.SelectCountCBCommand;
import org.seasar.dbflute.bhv.core.command.SelectCursorCBCommand;
import org.seasar.dbflute.bhv.core.command.SelectListCBCommand;
import org.seasar.dbflute.bhv.core.command.SelectNextValCommand;
import org.seasar.dbflute.bhv.core.command.SelectNextValSubCommand;
import org.seasar.dbflute.bhv.core.command.SelectScalarCBCommand;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.cbean.ScalarQuery;
import org.seasar.dbflute.cbean.UnionQuery;
import org.seasar.dbflute.cbean.coption.ScalarSelectOption;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.exception.DangerousResultSizeException;
import org.seasar.dbflute.exception.EntityPrimaryKeyNotFoundException;
import org.seasar.dbflute.exception.FetchingOverSafetySizeException;
import org.seasar.dbflute.exception.IllegalBehaviorStateException;
import org.seasar.dbflute.exception.PagingOverSafetySizeException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.seasar.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBehaviorReadable
implements BehaviorReadable {
    protected BehaviorCommandInvoker _behaviorCommandInvoker;
    protected BehaviorSelector _behaviorSelector;

    @Override
    public int readCount(ConditionBean cb) {
        this.assertCBNotNull(cb);
        return this.doReadCount(cb);
    }

    protected abstract int doReadCount(ConditionBean var1);

    @Override
    public Entity readEntity(ConditionBean cb) {
        this.assertCBNotNull(cb);
        return this.doReadEntity(cb);
    }

    protected abstract Entity doReadEntity(ConditionBean var1);

    @Override
    public Entity readEntityWithDeletedCheck(ConditionBean cb) {
        this.assertCBNotNull(cb);
        return this.doReadEntityWithDeletedCheck(cb);
    }

    protected abstract Entity doReadEntityWithDeletedCheck(ConditionBean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ENTITY extends Entity, CB extends ConditionBean> ENTITY helpSelectEntityInternally(CB cb, InternalSelectEntityCallback<ENTITY, CB> callback) {
        List<ENTITY> ls;
        this.assertCBNotNull(cb);
        if (!cb.hasWhereClause() && cb.getFetchSize() != 1) {
            this.throwSelectEntityConditionNotFoundException(cb);
        }
        int preSafetyMaxResultSize = this.xcheckSafetyResultAsOne(cb);
        try {
            ls = callback.callbackSelectList(cb);
        }
        catch (DangerousResultSizeException e) {
            this.throwSelectEntityDuplicatedException("{over safetyMaxResultSize '1'}", cb, e);
            ENTITY ENTITY = null;
            return ENTITY;
        }
        finally {
            this.xrestoreSafetyResult(cb, preSafetyMaxResultSize);
        }
        if (ls.isEmpty()) {
            return null;
        }
        this.assertEntitySelectedAsOne(ls, cb);
        return (ENTITY)((Entity)ls.get(0));
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> ENTITY helpSelectEntityWithDeletedCheckInternally(CB cb, final InternalSelectEntityWithDeletedCheckCallback<ENTITY, CB> callback) {
        this.assertCBNotNull(cb);
        ENTITY entity = this.helpSelectEntityInternally(cb, new InternalSelectEntityCallback<ENTITY, CB>(){

            @Override
            public List<ENTITY> callbackSelectList(CB cb) {
                return callback.callbackSelectList(cb);
            }
        });
        this.assertEntityNotDeleted((Entity)entity, (Object)cb);
        return entity;
    }

    protected int xcheckSafetyResultAsOne(ConditionBean cb) {
        int safetyMaxResultSize = cb.getSafetyMaxResultSize();
        cb.checkSafetyResult(1);
        return safetyMaxResultSize;
    }

    protected void xrestoreSafetyResult(ConditionBean cb, int preSafetyMaxResultSize) {
        cb.checkSafetyResult(preSafetyMaxResultSize);
    }

    @Override
    public <ENTITY extends Entity> ListResultBean<ENTITY> readList(ConditionBean cb) {
        this.assertCBNotNull(cb);
        ListResultBean<? extends Entity> entityList = this.doReadList(cb);
        return entityList;
    }

    protected abstract ListResultBean<? extends Entity> doReadList(ConditionBean var1);

    protected <ENTITY extends Entity> void assertSpecifyDerivedReferrerEntityProperty(ConditionBean cb, Class<ENTITY> entityType) {
        List<String> aliasList = cb.getSqlClause().getSpecifiedDerivingAliasList();
        for (String alias : aliasList) {
            Method[] methods = entityType.getMethods();
            String expectedName = "set" + Srl.replace(alias, "_", "");
            boolean exists = false;
            for (Method method : methods) {
                String methodName = method.getName();
                if (!methodName.startsWith("set") || !expectedName.equalsIgnoreCase(methodName)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.throwSpecifyDerivedReferrerEntityPropertyNotFoundException(alias, entityType);
        }
    }

    protected void throwSpecifyDerivedReferrerEntityPropertyNotFoundException(String alias, Class<?> entityType) {
        this.createCBExThrower().throwSpecifyDerivedReferrerEntityPropertyNotFoundException(alias, entityType);
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> ListResultBean<ENTITY> helpSelectListInternally(CB cb, Class<ENTITY> entityType, InternalSelectListCallback<ENTITY, CB> callback) {
        try {
            return this.createListResultBean(cb, callback.callbackSelectList(cb, entityType));
        }
        catch (FetchingOverSafetySizeException e) {
            this.createBhvExThrower().throwDangerousResultSizeException(cb, e);
            return null;
        }
    }

    protected <ENTITY extends Entity> ListResultBean<ENTITY> createListResultBean(ConditionBean cb, List<ENTITY> selectedList) {
        return new ResultBeanBuilder<ENTITY>(this.getTableDbName()).buildListResultBean(cb, selectedList);
    }

    @Override
    public <ENTITY extends Entity> PagingResultBean<ENTITY> readPage(ConditionBean cb) {
        this.assertCBNotNull(cb);
        PagingResultBean<? extends Entity> entityList = this.doReadPage(cb);
        return entityList;
    }

    protected abstract PagingResultBean<? extends Entity> doReadPage(ConditionBean var1);

    protected <ENTITY extends Entity, CB extends ConditionBean> PagingResultBean<ENTITY> helpSelectPageInternally(CB cb, Class<ENTITY> entityType, InternalSelectPageCallback<ENTITY, CB> callback) {
        try {
            PagingHandler<ENTITY> handler = this.createPagingHandler(cb, entityType, callback);
            PagingInvoker<ENTITY> invoker = this.createPagingInvoker(cb);
            return invoker.invokePaging(handler);
        }
        catch (PagingOverSafetySizeException e) {
            this.createBhvExThrower().throwDangerousResultSizeException(cb, e);
            return null;
        }
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> PagingHandler<ENTITY> createPagingHandler(final CB cb, final Class<ENTITY> entityType, final InternalSelectPageCallback<ENTITY, CB> callback) {
        return new PagingHandler<ENTITY>(){

            @Override
            public PagingBean getPagingBean() {
                return cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int count() {
                try {
                    cb.getSqlClause().makePagingAdjustmentEffective();
                    int n = callback.callbackSelectCount(cb);
                    return n;
                }
                finally {
                    cb.getSqlClause().ignorePagingAdjustment();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ENTITY> paging() {
                try {
                    cb.getSqlClause().makePagingAdjustmentEffective();
                    List list = callback.callbackSelectList(cb, entityType);
                    return list;
                }
                finally {
                    cb.getSqlClause().ignorePagingAdjustment();
                }
            }
        };
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> PagingInvoker<ENTITY> createPagingInvoker(CB cb) {
        return cb.createPagingInvoker(this.getTableDbName());
    }

    protected void assertEntityNotDeleted(Entity entity, Object searchKey) {
        if (entity == null) {
            this.throwSelectEntityAlreadyDeletedException(searchKey);
        }
    }

    protected void assertEntityNotDeleted(List<? extends Entity> ls, Object searchKey) {
        if (ls == null || ls.isEmpty()) {
            this.throwSelectEntityAlreadyDeletedException(searchKey);
        }
    }

    protected void assertEntitySelectedAsOne(List<? extends Entity> ls, Object searchKey) {
        if (ls == null || ls.isEmpty()) {
            this.throwSelectEntityAlreadyDeletedException(searchKey);
        }
        if (ls.size() > 1) {
            this.throwSelectEntityDuplicatedException(String.valueOf(ls.size()), searchKey, null);
        }
    }

    protected void throwSelectEntityAlreadyDeletedException(Object searchKey) {
        this.createBhvExThrower().throwSelectEntityAlreadyDeletedException(searchKey);
    }

    protected void throwSelectEntityDuplicatedException(String resultCountExp, Object searchKey, Throwable cause) {
        this.createBhvExThrower().throwSelectEntityDuplicatedException(resultCountExp, searchKey, cause);
    }

    protected void throwSelectEntityConditionNotFoundException(ConditionBean cb) {
        this.createBhvExThrower().throwSelectEntityConditionNotFoundException(cb);
    }

    @Override
    public <BEHAVIOR extends BehaviorReadable> OutsideSqlBasicExecutor<BEHAVIOR> readyOutsideSql() {
        return this.doOutsideSql();
    }

    protected <BEHAVIOR extends BehaviorReadable> OutsideSqlBasicExecutor<BEHAVIOR> doOutsideSql() {
        this.assertBehaviorCommandInvoker("outsideSql");
        return this._behaviorCommandInvoker.createOutsideSqlBasicExecutor(this.getTableDbName());
    }

    @Override
    public Number readNextVal() {
        return this.doReadNextVal();
    }

    protected abstract Number doReadNextVal();

    protected <LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> void helpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, InternalLoadReferrerCallback<LOCAL_ENTITY, PK, REFERRER_CB, REFERRER_ENTITY> callback) {
        this.doHelpLoadReferrerInternally(localEntityList, loadReferrerOption, callback);
    }

    protected <LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> void doHelpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, final InternalLoadReferrerCallback<LOCAL_ENTITY, PK, REFERRER_CB, REFERRER_ENTITY> callback) {
        PK referrerListKey;
        this.assertBehaviorSelectorNotNull("loadReferrer");
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
        if (localEntityList.isEmpty()) {
            return;
        }
        LinkedHashMap<PK, Entity> pkLocalEntityMap = new LinkedHashMap<PK, Entity>();
        final ArrayList<PK> pkList = new ArrayList<PK>();
        for (Entity localEntity : localEntityList) {
            PK primaryKeyValue = callback.getPKVal(localEntity);
            if (primaryKeyValue == null) {
                String msg = "PK value of local entity should not be null: " + localEntity;
                throw new IllegalArgumentException(msg);
            }
            pkList.add(primaryKeyValue);
            pkLocalEntityMap.put(this.toLoadReferrerMappingKey(primaryKeyValue), localEntity);
        }
        REFERRER_CB cb = loadReferrerOption.getReferrerConditionBean() != null ? loadReferrerOption.getReferrerConditionBean() : callback.newMyCB();
        callback.qyFKIn(cb, pkList);
        cb.xregisterUnionQuerySynchronizer(new UnionQuery<ConditionBean>(){

            @Override
            public void query(ConditionBean unionCB) {
                ConditionBean referrerUnionCB = unionCB;
                callback.qyFKIn(referrerUnionCB, pkList);
            }
        });
        if (pkList.size() > 1) {
            callback.qyOdFKAsc(cb);
            cb.getOrderByComponent().exchangeFirstOrderByElementForLastOne();
        }
        loadReferrerOption.delegateConditionBeanSettingUp(cb);
        if (cb.getSqlClause().hasSpecifiedSelectColumn(cb.getSqlClause().getBasePointAliasName())) {
            callback.spFKCol(cb);
        }
        List<REFERRER_ENTITY> referrerList = callback.selRfLs(cb);
        loadReferrerOption.delegateEntitySettingUp(referrerList);
        LinkedHashMap pkReferrerListMap = new LinkedHashMap();
        for (Entity referrerEntity : referrerList) {
            PK foreignKeyValue = callback.getFKVal(referrerEntity);
            referrerListKey = this.toLoadReferrerMappingKey(foreignKeyValue);
            if (!pkReferrerListMap.containsKey(referrerListKey)) {
                pkReferrerListMap.put(referrerListKey, new ArrayList());
            }
            ((List)pkReferrerListMap.get(referrerListKey)).add(referrerEntity);
            Entity localEntity = (Entity)pkLocalEntityMap.get(referrerListKey);
            callback.setlcEt(referrerEntity, localEntity);
        }
        for (Entity localEntity : localEntityList) {
            PK primaryKey = callback.getPKVal(localEntity);
            referrerListKey = this.toLoadReferrerMappingKey(primaryKey);
            if (pkReferrerListMap.containsKey(referrerListKey)) {
                callback.setRfLs(localEntity, (List)pkReferrerListMap.get(referrerListKey));
                continue;
            }
            callback.setRfLs(localEntity, new ArrayList());
        }
    }

    protected <PK> PK toLoadReferrerMappingKey(PK value) {
        return (PK)this.toLowerCaseIfString(value);
    }

    protected void xassLRArg(Entity entity, ConditionBeanSetupper<? extends ConditionBean> conditionBeanSetupper) {
        this.assertObjectNotNull("entity(" + DfTypeUtil.toClassTitle(this.getDBMeta().getEntityType()) + ")", entity);
        this.assertObjectNotNull("conditionBeanSetupper", conditionBeanSetupper);
    }

    protected void xassLRArg(List<? extends Entity> entityList, ConditionBeanSetupper<? extends ConditionBean> conditionBeanSetupper) {
        this.assertObjectNotNull("List<" + DfTypeUtil.toClassTitle(this.getDBMeta().getEntityType()) + ">", entityList);
        this.assertObjectNotNull("conditionBeanSetupper", conditionBeanSetupper);
    }

    protected void xassLRArg(Entity entity, LoadReferrerOption<? extends ConditionBean, ? extends Entity> loadReferrerOption) {
        this.assertObjectNotNull("entity(" + DfTypeUtil.toClassTitle(this.getDBMeta().getEntityType()) + ")", entity);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
    }

    protected void xassLRArg(List<? extends Entity> entityList, LoadReferrerOption<? extends ConditionBean, ? extends Entity> loadReferrerOption) {
        this.assertObjectNotNull("List<" + DfTypeUtil.toClassTitle(this.getDBMeta().getEntityType()) + ">", entityList);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
    }

    protected BehaviorSelector xgetBSFLR() {
        this.assertBehaviorSelectorNotNull("loadReferrer");
        return this.getBehaviorSelector();
    }

    private void assertBehaviorSelectorNotNull(String methodName) {
        if (this._behaviorSelector != null) {
            return;
        }
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the selector of behavior in the behavior!");
        br.addItem("Advice");
        br.addElement("Please confirm the definition of the selector at your component configuration of DBFlute.");
        br.addElement("It is precondition that '" + methodName + "()' needs the selector instance.");
        br.addItem("Behavior");
        br.addElement("Behavior for " + this.getTableDbName());
        br.addItem("Attribute");
        br.addElement("behaviorCommandInvoker   : " + this._behaviorCommandInvoker);
        br.addElement("behaviorSelector         : " + this._behaviorSelector);
        String msg = br.buildExceptionMessage();
        throw new IllegalBehaviorStateException(msg);
    }

    protected <ELEMENT> List<ELEMENT> xnewLRLs(ELEMENT element) {
        ArrayList<ELEMENT> ls = new ArrayList<ELEMENT>(1);
        ls.add(element);
        return ls;
    }

    protected <LOCAL_ENTITY extends Entity, FOREIGN_ENTITY extends Entity> List<FOREIGN_ENTITY> helpPulloutInternally(List<LOCAL_ENTITY> localEntityList, InternalPulloutCallback<LOCAL_ENTITY, FOREIGN_ENTITY> callback) {
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("callback", callback);
        LinkedHashSet<FOREIGN_ENTITY> foreignSet = new LinkedHashSet<FOREIGN_ENTITY>();
        LinkedHashMap foreignReferrerMap = new LinkedHashMap();
        boolean existsReferrer = callback.hasRf();
        for (Entity entity : localEntityList) {
            FOREIGN_ENTITY foreignEntity = callback.getFr(entity);
            if (foreignEntity == null) continue;
            if (!foreignSet.contains(foreignEntity)) {
                foreignSet.add(foreignEntity);
            }
            if (!existsReferrer) continue;
            if (!foreignReferrerMap.containsKey(foreignEntity)) {
                foreignReferrerMap.put(foreignEntity, new ArrayList());
            }
            ((List)foreignReferrerMap.get(foreignEntity)).add(entity);
        }
        Set entrySet = foreignReferrerMap.entrySet();
        for (Map.Entry entry : entrySet) {
            callback.setRfLs((Entity)entry.getKey(), (List)entry.getValue());
        }
        return new ArrayList(foreignSet);
    }

    protected void filterEntityOfInsert(Entity targetEntity, InsertOption<? extends ConditionBean> option) {
    }

    @Override
    public void warmUpCommand() {
        SelectCountCBCommand cmd = this.createSelectCountCBCommand(this.newConditionBean(), true);
        cmd.setInitializeOnly(true);
        this.invoke(cmd);
        cmd = this.createSelectCountCBCommand(this.newConditionBean(), false);
        cmd.setInitializeOnly(true);
        this.invoke(cmd);
        Class<? extends Entity> entityType = this.getDBMeta().getEntityType();
        SelectListCBCommand<? extends Entity> cmd2 = this.createSelectListCBCommand(this.newConditionBean(), entityType);
        cmd2.setInitializeOnly(true);
        this.invoke(cmd2);
    }

    protected SelectCountCBCommand createSelectCountCBCommand(ConditionBean cb, boolean uniqueCount) {
        this.assertBehaviorCommandInvoker("createSelectCountCBCommand");
        SelectCountCBCommand cmd = this.xsetupSelectCommand(new SelectCountCBCommand());
        cmd.setConditionBean(cb);
        cmd.setUniqueCount(uniqueCount);
        return cmd;
    }

    protected <ENTITY extends Entity> SelectCursorCBCommand<ENTITY> createSelectCursorCBCommand(ConditionBean cb, EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        this.assertBehaviorCommandInvoker("createSelectCursorCBCommand");
        SelectCursorCBCommand<ENTITY> cmd = this.xsetupSelectCommand(new SelectCursorCBCommand());
        cmd.setConditionBean(cb);
        cmd.setEntityType(entityType);
        cmd.setEntityRowHandler(entityRowHandler);
        return cmd;
    }

    protected <ENTITY extends Entity> SelectListCBCommand<ENTITY> createSelectListCBCommand(ConditionBean cb, Class<ENTITY> entityType) {
        this.assertBehaviorCommandInvoker("createSelectListCBCommand");
        SelectListCBCommand<ENTITY> cmd = this.xsetupSelectCommand(new SelectListCBCommand());
        cmd.setConditionBean(cb);
        cmd.setEntityType(entityType);
        return cmd;
    }

    protected <RESULT> SelectNextValCommand<RESULT> createSelectNextValCommand(Class<RESULT> resultType) {
        this.assertBehaviorCommandInvoker("createSelectNextValCommand");
        SelectNextValCommand<RESULT> cmd = this.xsetupSelectCommand(new SelectNextValCommand());
        cmd.setResultType(resultType);
        cmd.setDBMeta(this.getDBMeta());
        cmd.setSequenceCacheHandler(this._behaviorCommandInvoker.getSequenceCacheHandler());
        return cmd;
    }

    protected <RESULT> SelectNextValCommand<RESULT> createSelectNextValSubCommand(Class<RESULT> resultType, String columnDbName, String sequenceName, Integer incrementSize, Integer cacheSize) {
        this.assertBehaviorCommandInvoker("createSelectNextValCommand");
        SelectNextValSubCommand<RESULT> cmd = this.xsetupSelectCommand(new SelectNextValSubCommand());
        cmd.setResultType(resultType);
        cmd.setDBMeta(this.getDBMeta());
        cmd.setSequenceCacheHandler(this._behaviorCommandInvoker.getSequenceCacheHandler());
        cmd.setColumnInfo(this.getDBMeta().findColumnInfo(columnDbName));
        cmd.setSequenceName(sequenceName);
        cmd.setIncrementSize(incrementSize);
        cmd.setCacheSize(cacheSize);
        return cmd;
    }

    protected <RESULT> SelectScalarCBCommand<RESULT> createSelectScalarCBCommand(ConditionBean cb, Class<RESULT> resultType, SqlClause.SelectClauseType selectClauseType) {
        this.assertBehaviorCommandInvoker("createSelectScalarCBCommand");
        SelectScalarCBCommand<RESULT> cmd = this.xsetupSelectCommand(new SelectScalarCBCommand());
        cmd.setConditionBean(cb);
        cmd.setResultType(resultType);
        cmd.setSelectClauseType(selectClauseType);
        return cmd;
    }

    protected <COMMAND extends AbstractBehaviorCommand<?>> COMMAND xsetupSelectCommand(COMMAND cmd) {
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        return cmd;
    }

    protected InsertEntityCommand createInsertEntityCommand(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createInsertEntityCommand");
        InsertEntityCommand cmd = this.xsetupEntityCommand(new InsertEntityCommand(), entity);
        cmd.setInsertOption(option);
        return cmd;
    }

    protected <COMMAND extends AbstractEntityCommand> COMMAND xsetupEntityCommand(COMMAND cmd, Entity entity) {
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setEntity(entity);
        return cmd;
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    protected void assertBehaviorCommandInvoker(String methodName) {
        if (this._behaviorCommandInvoker != null) {
            return;
        }
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the invoker of behavior command in the behavior!");
        br.addItem("Advice");
        br.addElement("Please confirm the definition of the set-upper at your component configuration of DBFlute.");
        br.addElement("It is precondition that '" + methodName + "()' needs the invoker instance.");
        br.addItem("Behavior");
        br.addElement("Behavior for " + this.getTableDbName());
        br.addItem("Attribute");
        br.addElement("behaviorCommandInvoker   : " + this._behaviorCommandInvoker);
        br.addElement("behaviorSelector         : " + this._behaviorSelector);
        String msg = br.buildExceptionMessage();
        throw new IllegalBehaviorStateException(msg);
    }

    protected abstract boolean hasVersionNoValue(Entity var1);

    protected abstract boolean hasUpdateDateValue(Entity var1);

    protected <ENTITY extends Entity> ENTITY helpEntityDowncastInternally(Entity entity, Class<ENTITY> clazz) {
        this.assertObjectNotNull("entity", entity);
        this.assertObjectNotNull("clazz", clazz);
        try {
            return (ENTITY)entity;
        }
        catch (ClassCastException e) {
            String msg = "The entity should be " + DfTypeUtil.toClassTitle(clazz);
            msg = msg + " but it was: " + entity.getClass();
            throw new IllegalStateException(msg, e);
        }
    }

    protected <CB extends ConditionBean> CB helpConditionBeanDowncastInternally(ConditionBean cb, Class<CB> clazz) {
        this.assertObjectNotNull("cb", cb);
        this.assertObjectNotNull("clazz", clazz);
        try {
            return (CB)cb;
        }
        catch (ClassCastException e) {
            String msg = "The condition-bean should be " + DfTypeUtil.toClassTitle(clazz);
            msg = msg + " but it was: " + cb.getClass();
            throw new IllegalStateException(msg, e);
        }
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        this.assertBehaviorCommandInvoker("createBhvExThrower");
        return this._behaviorCommandInvoker.createBehaviorExceptionThrower();
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected ExceptionMessageBuilder createExceptionMessageBuilder() {
        return new ExceptionMessageBuilder();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertEntityNotNull(Entity entity) {
        this.assertObjectNotNull("entity", entity);
    }

    protected void assertConditionBeanNotNull(ConditionBean cb) {
        this.assertCBNotNull(cb);
    }

    protected void assertCBNotNull(ConditionBean cb) {
        this.assertObjectNotNull("cb", cb);
    }

    protected void assertEntityNotNullAndHasPrimaryKeyValue(Entity entity) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            this.throwEntityPrimaryKeyNotFoundException(entity);
        }
    }

    protected void throwEntityPrimaryKeyNotFoundException(Entity entity) {
        String classTitle = DfTypeUtil.toClassTitle(entity);
        String behaviorName = Srl.substringLastRear(entity.getDBMeta().getBehaviorTypeName(), ".");
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The primary-key value in the entity was not found.");
        br.addItem("Advice");
        br.addElement("An entity should have its primary-key value when e.g. insert(), update().");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    " + classTitle + " entiity = new " + classTitle + "();");
        br.addElement("    entity.setFooName(...);");
        br.addElement("    entity.setFooDate(...);");
        br.addElement("    " + behaviorName + ".updateNonstrict(entity);");
        br.addElement("  (o):");
        br.addElement("    " + classTitle + " entiity = new " + classTitle + "();");
        br.addElement("    entity.setFooId(...); // *Point");
        br.addElement("    entity.setFooName(...);");
        br.addElement("    entity.setFooDate(...);");
        br.addElement("    " + behaviorName + ".updateNonstrict(entity);");
        br.addElement("Or if your process is insert(), you might expect identity.");
        br.addElement("Confirm the primary-key's identity setting.");
        br.addItem("Entity");
        br.addElement(entity);
        String msg = br.buildExceptionMessage();
        throw new EntityPrimaryKeyNotFoundException(msg);
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndEmpty(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (!ls.isEmpty()) {
            String msg = "The list should be empty: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndNotEmpty(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (ls.isEmpty()) {
            String msg = "The list should not be empty: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndHasOnlyOne(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (ls.size() != 1) {
            String msg = "The list should contain only one object: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected Object toLowerCaseIfString(Object obj) {
        if (obj != null && obj instanceof String) {
            return ((String)obj).toLowerCase();
        }
        return obj;
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected BehaviorCommandInvoker getBehaviorCommandInvoker() {
        return this._behaviorCommandInvoker;
    }

    public void setBehaviorCommandInvoker(BehaviorCommandInvoker behaviorCommandInvoker) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
    }

    protected BehaviorSelector getBehaviorSelector() {
        return this._behaviorSelector;
    }

    public void setBehaviorSelector(BehaviorSelector behaviorSelector) {
        this._behaviorSelector = behaviorSelector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalPulloutCallback<LOCAL_ENTITY extends Entity, FOREIGN_ENTITY extends Entity> {
        public FOREIGN_ENTITY getFr(LOCAL_ENTITY var1);

        public boolean hasRf();

        public void setRfLs(FOREIGN_ENTITY var1, List<LOCAL_ENTITY> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalLoadReferrerCallback<LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> {
        public PK getPKVal(LOCAL_ENTITY var1);

        public void setRfLs(LOCAL_ENTITY var1, List<REFERRER_ENTITY> var2);

        public REFERRER_CB newMyCB();

        public void qyFKIn(REFERRER_CB var1, List<PK> var2);

        public void qyOdFKAsc(REFERRER_CB var1);

        public void spFKCol(REFERRER_CB var1);

        public List<REFERRER_ENTITY> selRfLs(REFERRER_CB var1);

        public PK getFKVal(REFERRER_ENTITY var1);

        public void setlcEt(REFERRER_ENTITY var1, LOCAL_ENTITY var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SLFunction<CB extends ConditionBean, RESULT> {
        protected CB _conditionBean;
        protected Class<RESULT> _resultType;
        final /* synthetic */ AbstractBehaviorReadable this$0;

        public SLFunction(CB conditionBean, Class<RESULT> resultType) {
            this.this$0 = var1_1;
            this._conditionBean = conditionBean;
            this._resultType = resultType;
        }

        public RESULT max(ScalarQuery<CB> scalarQuery) {
            return this.doMax(scalarQuery, null);
        }

        public RESULT max(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarSelectOption(option);
            return this.doMax(scalarQuery, option);
        }

        protected RESULT doMax(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarQuery(scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.MAX, option);
        }

        public RESULT min(ScalarQuery<CB> scalarQuery) {
            return this.doMin(scalarQuery, null);
        }

        public RESULT min(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarSelectOption(option);
            return this.doMin(scalarQuery, option);
        }

        protected RESULT doMin(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarQuery(scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.MIN, option);
        }

        public RESULT sum(ScalarQuery<CB> scalarQuery) {
            return this.doSum(scalarQuery, null);
        }

        public RESULT sum(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarSelectOption(option);
            return this.doSum(scalarQuery, option);
        }

        protected RESULT doSum(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarQuery(scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.SUM, option);
        }

        public RESULT avg(ScalarQuery<CB> scalarQuery) {
            return this.doAvg(scalarQuery, null);
        }

        public RESULT avg(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarSelectOption(option);
            return this.doAvg(scalarQuery, option);
        }

        protected RESULT doAvg(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
            this.assertScalarQuery(scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.AVG, option);
        }

        protected RESULT exec(ScalarQuery<CB> scalarQuery, SqlClause.SelectClauseType selectClauseType, ScalarSelectOption option) {
            this.this$0.assertObjectNotNull("scalarQuery", scalarQuery);
            this.this$0.assertObjectNotNull("selectClauseType", (Object)selectClauseType);
            this.this$0.assertObjectNotNull("conditionBean", this._conditionBean);
            this.this$0.assertObjectNotNull("resultType", this._resultType);
            scalarQuery.query(this._conditionBean);
            this.setupTargetColumnInfo(option);
            this.setupScalarSelectOption(option);
            this.assertScalarSelectRequiredSpecifyColumn();
            return this.this$0.invoke(this.this$0.createSelectScalarCBCommand((ConditionBean)this._conditionBean, this._resultType, selectClauseType));
        }

        protected void setupTargetColumnInfo(ScalarSelectOption option) {
            if (option == null) {
                return;
            }
            SqlClause sqlClause = this._conditionBean.getSqlClause();
            ColumnInfo columnInfo = sqlClause.getSpecifiedColumnInfoAsOne();
            if (columnInfo != null) {
                columnInfo = sqlClause.getSpecifiedDerivingColumnInfoAsOne();
            }
            option.xsetTargetColumnInfo(columnInfo);
        }

        protected void setupScalarSelectOption(ScalarSelectOption option) {
            if (option != null) {
                this._conditionBean.xacceptScalarSelectOption(option);
                this._conditionBean.localCQ().xregisterParameterOption(option);
            }
        }

        protected void assertScalarSelectRequiredSpecifyColumn() {
            SqlClause sqlClause = this._conditionBean.getSqlClause();
            String columnName = sqlClause.getSpecifiedColumnDbNameAsOne();
            String subQuery = sqlClause.getSpecifiedDerivingSubQueryAsOne();
            if (columnName != null && subQuery != null || columnName == null && subQuery == null) {
                this.throwScalarSelectInvalidColumnSpecificationException();
            }
        }

        protected void throwScalarSelectInvalidColumnSpecificationException() {
            this.this$0.createCBExThrower().throwScalarSelectInvalidColumnSpecificationException((ConditionBean)this._conditionBean, this._resultType);
        }

        protected void assertScalarQuery(ScalarQuery<?> scalarQuery) {
            if (scalarQuery == null) {
                String msg = "The argument 'scalarQuery' for ScalarSelect should not be null.";
                throw new IllegalArgumentException(msg);
            }
        }

        protected void assertScalarSelectOption(ScalarSelectOption option) {
            if (option == null) {
                String msg = "The argument 'option' for ScalarSelect should not be null.";
                throw new IllegalArgumentException(msg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalSelectPageCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public int callbackSelectCount(CB var1);

        public List<ENTITY> callbackSelectList(CB var1, Class<ENTITY> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalSelectListCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public List<ENTITY> callbackSelectList(CB var1, Class<ENTITY> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalSelectEntityWithDeletedCheckCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public List<ENTITY> callbackSelectList(CB var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalSelectEntityCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public List<ENTITY> callbackSelectList(CB var1);
    }
}

