/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute;

import org.seasar.dbflute.bhv.core.BehaviorCommandHook;
import org.seasar.dbflute.jdbc.SqlLogHandler;
import org.seasar.dbflute.jdbc.SqlResultHandler;

public class CallbackContext {
    private static final ThreadLocal<CallbackContext> _threadLocal = new ThreadLocal();
    protected BehaviorCommandHook _behaviorCommandHook;
    protected SqlLogHandler _sqlLogHandler;
    protected SqlResultHandler _sqlResultHandler;

    public static CallbackContext getCallbackContextOnThread() {
        return _threadLocal.get();
    }

    public static void setCallbackContextOnThread(CallbackContext callbackContext) {
        if (callbackContext == null) {
            String msg = "The argument[callbackContext] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _threadLocal.set(callbackContext);
    }

    public static boolean isExistCallbackContextOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearCallbackContextOnThread() {
        _threadLocal.set(null);
    }

    public static void setBehaviorCommandHookOnThread(BehaviorCommandHook behaviorCommandHook) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setBehaviorCommandHook(behaviorCommandHook);
    }

    public static boolean isExistBehaviorCommandHookOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getBehaviorCommandHook() != null;
    }

    public static void clearBehaviorCommandHookOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setBehaviorCommandHook(null);
            if (!context.hasAnyInterface()) {
                CallbackContext.clearCallbackContextOnThread();
            }
        }
    }

    public static void setSqlLogHandlerOnThread(SqlLogHandler sqlLogHandler) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlLogHandler(sqlLogHandler);
    }

    public static boolean isExistSqlLogHandlerOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlLogHandler() != null;
    }

    public static void clearSqlLogHandlerOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setSqlLogHandler(null);
            if (!context.hasAnyInterface()) {
                CallbackContext.clearCallbackContextOnThread();
            }
        }
    }

    public static void setSqlResultHandlerOnThread(SqlResultHandler sqlResultHandler) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlResultHandler(sqlResultHandler);
    }

    public static boolean isExistSqlResultHandlerOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlResultHandler() != null;
    }

    public static void clearSqlResultHandlerOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setSqlResultHandler(null);
            if (!context.hasAnyInterface()) {
                CallbackContext.clearCallbackContextOnThread();
            }
        }
    }

    protected static CallbackContext getOrCreateContext() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            return CallbackContext.getCallbackContextOnThread();
        }
        CallbackContext context = new CallbackContext();
        CallbackContext.setCallbackContextOnThread(context);
        return context;
    }

    public boolean hasAnyInterface() {
        return this._behaviorCommandHook != null || this._sqlLogHandler != null || this._sqlResultHandler != null;
    }

    public BehaviorCommandHook getBehaviorCommandHook() {
        return this._behaviorCommandHook;
    }

    public void setBehaviorCommandHook(BehaviorCommandHook behaviorCommandHook) {
        this._behaviorCommandHook = behaviorCommandHook;
    }

    public SqlLogHandler getSqlLogHandler() {
        return this._sqlLogHandler;
    }

    public void setSqlLogHandler(SqlLogHandler sqlLogHandler) {
        this._sqlLogHandler = sqlLogHandler;
    }

    public SqlResultHandler getSqlResultHandler() {
        return this._sqlResultHandler;
    }

    public void setSqlResultHandler(SqlResultHandler sqlResultHandler) {
        this._sqlResultHandler = sqlResultHandler;
    }
}

