/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Import_impl
extends MetaDataObject_impl
implements Import {
    private static final long serialVersionUID = 6876757002913848998L;
    private String mName;
    private String mLocation;

    public String getName() {
        return this.mName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public void setLocation(String aUri) {
        this.mLocation = aUri;
    }

    public URL findAbsoluteUrl(ResourceManager aResourceManager) throws InvalidXMLException {
        if (this.getLocation() != null) {
            try {
                return new URL(this.getRelativePathBase(), this.getLocation());
            }
            catch (MalformedURLException e) {
                throw new InvalidXMLException("malformed_import_url", new Object[]{this.getLocation(), this.getSourceUrlString()}, e);
            }
        }
        if (this.getName() != null) {
            URL url;
            String filename = this.getName().replace('.', '/') + ".xml";
            try {
                url = aResourceManager.resolveRelativePath(filename);
            }
            catch (MalformedURLException e) {
                throw new InvalidXMLException("import_by_name_target_not_found", new Object[]{this.getName(), this.getSourceUrlString()}, e);
            }
            if (url == null) {
                throw new InvalidXMLException("import_by_name_target_not_found", new Object[]{this.getName(), this.getSourceUrlString()});
            }
            return url;
        }
        throw new InvalidXMLException("import_must_have_name_xor_location", new Object[]{this.getSourceUrlString()});
    }

    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        String name = aElement.getAttribute("name");
        this.setName(name.length() == 0 ? null : name);
        String location = aElement.getAttribute("location");
        this.setLocation(location.length() == 0 ? null : location);
        if (!(this.getName() == null ^ this.getLocation() == null)) {
            throw new InvalidXMLException("import_must_have_name_xor_location", new Object[0]);
        }
    }

    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        if (this.getName() != null) {
            attrs.addAttribute("", "name", "name", null, this.getName());
        }
        if (this.getLocation() != null) {
            attrs.addAttribute("", "location", "location", null, this.getLocation());
        }
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "import", "import", attrs);
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "import", "import");
    }

    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo(null, null);
    }
}

