/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tika.parser.html.HtmlMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHtmlMapper
implements HtmlMapper {
    private static final Map<String, String> SAFE_ELEMENTS = new HashMap<String, String>(){
        {
            this.put("H1", "h1");
            this.put("H2", "h2");
            this.put("H3", "h3");
            this.put("H4", "h4");
            this.put("H5", "h5");
            this.put("H6", "h6");
            this.put("P", "p");
            this.put("PRE", "pre");
            this.put("BLOCKQUOTE", "blockquote");
            this.put("Q", "q");
            this.put("UL", "ul");
            this.put("OL", "ol");
            this.put("MENU", "ul");
            this.put("LI", "li");
            this.put("DL", "dl");
            this.put("DT", "dt");
            this.put("DD", "dd");
            this.put("TABLE", "table");
            this.put("THEAD", "thead");
            this.put("TBODY", "tbody");
            this.put("TR", "tr");
            this.put("TH", "th");
            this.put("TD", "td");
            this.put("ADDRESS", "address");
            this.put("A", "a");
            this.put("MAP", "map");
            this.put("AREA", "area");
            this.put("IMG", "img");
            this.put("FRAMESET", "frameset");
            this.put("FRAME", "frame");
            this.put("IFRAME", "iframe");
            this.put("OBJECT", "object");
            this.put("PARAM", "param");
            this.put("INS", "ins");
            this.put("DEL", "del");
        }
    };
    private static final Set<String> DISCARDABLE_ELEMENTS = new HashSet<String>(){
        {
            this.add("STYLE");
            this.add("SCRIPT");
        }
    };
    private static final Map<String, Set<String>> SAFE_ATTRIBUTES = new HashMap<String, Set<String>>(){
        {
            this.put("a", DefaultHtmlMapper.attrSet(new String[]{"charset", "type", "name", "href", "hreflang", "rel", "rev", "shape", "coords"}));
            this.put("img", DefaultHtmlMapper.attrSet(new String[]{"src", "alt", "longdesc", "height", "width", "usemap", "ismap"}));
            this.put("frame", DefaultHtmlMapper.attrSet(new String[]{"longdesc", "name", "src", "frameborder", "marginwidth", "marginheight", "noresize", "scrolling"}));
            this.put("iframe", DefaultHtmlMapper.attrSet(new String[]{"longdesc", "name", "src", "frameborder", "marginwidth", "marginheight", "scrolling", "align", "height", "width"}));
            this.put("link", DefaultHtmlMapper.attrSet(new String[]{"charset", "href", "hreflang", "type", "rel", "rev", "media"}));
            this.put("map", DefaultHtmlMapper.attrSet(new String[]{"id", "class", "style", "title", "name"}));
            this.put("area", DefaultHtmlMapper.attrSet(new String[]{"shape", "coords", "href", "nohref", "alt"}));
            this.put("object", DefaultHtmlMapper.attrSet(new String[]{"declare", "classid", "codebase", "data", "type", "codetype", "archive", "standby", "height", "width", "usemap", "name", "tabindex", "align", "border", "hspace", "vspace"}));
            this.put("param", DefaultHtmlMapper.attrSet(new String[]{"id", "name", "value", "valuetype", "type"}));
            this.put("blockquote", DefaultHtmlMapper.attrSet(new String[]{"cite"}));
            this.put("ins", DefaultHtmlMapper.attrSet(new String[]{"cite", "datetime"}));
            this.put("del", DefaultHtmlMapper.attrSet(new String[]{"cite", "datetime"}));
            this.put("q", DefaultHtmlMapper.attrSet(new String[]{"cite"}));
        }
    };
    public static final HtmlMapper INSTANCE = new DefaultHtmlMapper();

    private static Set<String> attrSet(String ... attrs) {
        HashSet<String> result = new HashSet<String>();
        for (String attr : attrs) {
            result.add(attr);
        }
        return result;
    }

    @Override
    public String mapSafeElement(String name) {
        return SAFE_ELEMENTS.get(name);
    }

    @Override
    public String mapSafeAttribute(String elementName, String attributeName) {
        Set<String> safeAttrs = SAFE_ATTRIBUTES.get(elementName);
        if (safeAttrs != null && safeAttrs.contains(attributeName)) {
            return attributeName;
        }
        return null;
    }

    @Override
    public boolean isDiscardElement(String name) {
        return DISCARDABLE_ELEMENTS.contains(name);
    }
}

