/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.vodafone;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class ContentDistributorIdBox
extends AbstractFullBox {
    public static final String TYPE = "cdis";
    private String language;
    private String contentDistributorId;

    public ContentDistributorIdBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getContentDistributorId() {
        return this.contentDistributorId;
    }

    protected long getContentSize() {
        return 2 + ContentDistributorIdBox.utf8StringLengthInBytes(this.contentDistributorId) + 1;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.language = in.readIso639();
        this.contentDistributorId = in.readString();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeIso639(this.language);
        isos.writeStringZeroTerm(this.contentDistributorId);
    }

    public String toString() {
        return "ContentDistributorIdBox[language=" + this.getLanguage() + ";contentDistributorId=" + this.getContentDistributorId() + "]";
    }
}

