/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.IsoOutputStream;
import java.io.IOException;

public class SampleFlags {
    private int reserved;
    private int sampleDependsOn;
    private int sampleHasRedundancy;
    private int samplePaddingValue;
    private boolean sampleIsDifferenceSample;
    private int sampleDegradationPriority;

    public SampleFlags(long flags) {
        this.reserved = (int)(flags >> 26);
        this.sampleDependsOn = (int)(flags >> 24) & 3;
        this.sampleHasRedundancy = (int)(flags >> 22) & 3;
        this.samplePaddingValue = (int)(flags >> 19) & 7;
        this.sampleIsDifferenceSample = (flags >> 18 & 1L) == 1L;
        this.sampleDegradationPriority = (int)flags & 0xFFFF;
    }

    public String toString() {
        return "SampleFlags{reserved=" + this.reserved + ", sampleDependsOn=" + this.sampleDependsOn + ", sampleHasRedundancy=" + this.sampleHasRedundancy + ", samplePaddingValue=" + this.samplePaddingValue + ", sampleIsDifferenceSample=" + this.sampleIsDifferenceSample + ", sampleDegradationPriority=" + this.sampleDegradationPriority + '}';
    }

    public void getContent(IsoOutputStream os) throws IOException {
        long flags = this.reserved << 26;
        flags |= (long)(this.sampleDependsOn << 24);
        flags |= (long)(this.sampleHasRedundancy << 22);
        flags |= (long)(this.samplePaddingValue << 19);
        flags |= (long)((this.sampleIsDifferenceSample ? 1 : 0) << 18);
        os.writeUInt32(flags |= (long)this.sampleDegradationPriority);
    }
}

