/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditListBox
extends AbstractFullBox {
    private List<Entry> entries = new LinkedList<Entry>();
    public static final String TYPE = "elst";

    public EditListBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    @Override
    protected long getContentSize() {
        long contentSize = 4L;
        contentSize = this.getVersion() == 1 ? (contentSize += (long)(this.entries.size() * 20)) : (contentSize += (long)(this.entries.size() * 12));
        return contentSize;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long entryCount = in.readUInt32();
        if (entryCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.entries = new LinkedList<Entry>();
        int i = 0;
        while ((long)i < entryCount) {
            this.entries.add(new Entry(this, in));
            ++i;
        }
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt32(this.entries.size());
        for (Entry entry : this.entries) {
            entry.getContent(isos);
        }
    }

    public String toString() {
        return "EditListBox{entries=" + this.entries + '}';
    }

    public static class Entry {
        private long segmentDuration;
        private long mediaTime;
        private double mediaRate;
        EditListBox editListBox;

        public Entry(EditListBox editListBox, long segmentDuration, long mediaTime, double mediaRate) {
            this.segmentDuration = segmentDuration;
            this.mediaTime = mediaTime;
            this.mediaRate = mediaRate;
            this.editListBox = editListBox;
        }

        public Entry(EditListBox editListBox, IsoBufferWrapper in) throws IOException {
            if (editListBox.getVersion() == 1) {
                this.segmentDuration = in.readUInt64();
                this.mediaTime = in.readUInt64();
                this.mediaRate = in.readFixedPoint1616();
            } else {
                this.segmentDuration = in.readUInt32();
                this.mediaTime = in.readUInt32();
                this.mediaRate = in.readFixedPoint1616();
            }
            this.editListBox = editListBox;
        }

        public long getSegmentDuration() {
            return this.segmentDuration;
        }

        public void setSegmentDuration(long segmentDuration) {
            this.segmentDuration = segmentDuration;
        }

        public long getMediaTime() {
            return this.mediaTime;
        }

        public void setMediaTime(long mediaTime) {
            this.mediaTime = mediaTime;
        }

        public double getMediaRate() {
            return this.mediaRate;
        }

        public void setMediaRate(double mediaRate) {
            this.mediaRate = mediaRate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.mediaTime != entry.mediaTime) {
                return false;
            }
            return this.segmentDuration == entry.segmentDuration;
        }

        public int hashCode() {
            int result = (int)(this.segmentDuration ^ this.segmentDuration >>> 32);
            result = 31 * result + (int)(this.mediaTime ^ this.mediaTime >>> 32);
            return result;
        }

        public void getContent(IsoOutputStream isos) throws IOException {
            if (this.editListBox.getVersion() == 1) {
                isos.writeUInt64(this.segmentDuration);
                isos.writeUInt64(this.mediaTime);
            } else {
                isos.writeUInt32((int)this.segmentDuration);
                isos.writeUInt32((int)this.mediaTime);
            }
            isos.writeFixedPont1616(this.mediaRate);
        }

        public String toString() {
            return "Entry{segmentDuration=" + this.segmentDuration + ", mediaTime=" + this.mediaTime + ", mediaRate=" + this.mediaRate + '}';
        }
    }
}

