/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.unit;

import java.util.Collection;
import org.seasar.framework.jpa.PersistenceUnitManager;
import org.seasar.framework.jpa.PersistenceUnitManagerLocater;
import org.seasar.framework.jpa.PersistenceUnitProvider;
import org.seasar.framework.jpa.unit.EntityReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityReaderFactory {
    public static EntityReader getEntityReader(Object entity) {
        Class<?> entityClass = entity.getClass();
        PersistenceUnitManager manager = PersistenceUnitManagerLocater.getInstance();
        PersistenceUnitProvider provider = manager.getPersistenceUnitProvider(entityClass);
        return provider.getEntityReaderProvider().createEntityReader(entity);
    }

    public static EntityReader getEntityReader(Collection<?> entities) {
        if (entities == null || entities.isEmpty()) {
            return null;
        }
        Class<?> entityClass = entities.iterator().next().getClass();
        PersistenceUnitManager manager = PersistenceUnitManagerLocater.getInstance();
        PersistenceUnitProvider provider = manager.getPersistenceUnitProvider(entityClass);
        return provider.getEntityReaderProvider().createEntityReader(entities);
    }
}

