/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory.aspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.annotation.Interceptor;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.AspectDefFactory;
import org.seasar.framework.container.factory.aspect.AbstractAspectDefBuilder;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaAnnotationAspectDefBuilder
extends AbstractAspectDefBuilder {
    protected Class<? extends Annotation> metaAnnotationType;
    protected String interceptorNamespace;
    protected String interceptorSuffix;

    public MetaAnnotationAspectDefBuilder() {
    }

    public MetaAnnotationAspectDefBuilder(Class<? extends Annotation> metaAnnotationType, String interceptorSuffix) {
        this.metaAnnotationType = metaAnnotationType;
        this.interceptorNamespace = null;
        this.interceptorSuffix = interceptorSuffix;
    }

    public MetaAnnotationAspectDefBuilder(Class<? extends Annotation> metaAnnotationType, String interceptorNamespace, String interceptorSuffix) {
        this.metaAnnotationType = metaAnnotationType;
        this.interceptorNamespace = interceptorNamespace;
        this.interceptorSuffix = interceptorSuffix;
    }

    public Class<? extends Annotation> getMetaAnnotationType() {
        return this.metaAnnotationType;
    }

    public void setMetaAnnotationType(Class<? extends Annotation> metaAnnotationType) {
        this.metaAnnotationType = metaAnnotationType;
    }

    public String getInterceptorNamespace() {
        return this.interceptorNamespace;
    }

    public void setInterceptorNamespace(String interceptorNamespace) {
        this.interceptorNamespace = interceptorNamespace;
    }

    public String getInterceptorSuffix() {
        return this.interceptorSuffix;
    }

    public void setInterceptorSuffix(String interceptorSuffix) {
        this.interceptorSuffix = interceptorSuffix;
    }

    @Override
    public void appendAspectDef(AnnotationHandler annotationHandler, ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        this.processClass(componentDef, componentClass);
        this.processMethod(componentDef, componentClass);
    }

    protected void processClass(ComponentDef componentDef, Class<?> componentClass) {
        for (Annotation annotation : componentClass.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Annotation metaAnnotation = annotationType.getAnnotation(this.getMetaAnnotationType());
            if (metaAnnotation == null) continue;
            String pointcut = this.getPointcut(annotation);
            AspectDefImpl aspectDef = new AspectDefImpl();
            if (!StringUtil.isEmpty((String)pointcut)) {
                aspectDef.setPointcut(AspectDefFactory.createPointcut((String)pointcut));
            }
            aspectDef.setExpression((Expression)new ExpressionImpl(annotation));
            componentDef.addAspectDef((AspectDef)aspectDef);
        }
    }

    protected void processMethod(ComponentDef componentDef, Class<?> componentClass) {
        for (Method method : componentClass.getMethods()) {
            int modifiers;
            if (method.isBridge() || method.isSynthetic() || !Modifier.isPublic(modifiers = method.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            for (Annotation annotation : method.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                Annotation metaAnnotation = annotationType.getAnnotation(this.getMetaAnnotationType());
                if (metaAnnotation == null) continue;
                AspectDefImpl aspectDef = new AspectDefImpl((Pointcut)new PointcutImpl(method));
                aspectDef.setExpression((Expression)new ExpressionImpl(annotation));
                componentDef.addAspectDef((AspectDef)aspectDef);
            }
        }
    }

    protected String getPointcut(Annotation annotation) {
        for (Method method : annotation.getClass().getMethods()) {
            if (method.isBridge() || method.isSynthetic() || !"pointcut".equals(method.getName()) || method.getReturnType() != String.class) continue;
            return (String)String.class.cast(MethodUtil.invoke((Method)method, (Object)annotation, null));
        }
        return null;
    }

    protected String getInterceptorName(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Interceptor interceptor = annotationType.getAnnotation(Interceptor.class);
        String value = interceptor.value();
        if (!StringUtil.isEmpty((String)value)) {
            return value;
        }
        String namespace = this.getInterceptorNamespace();
        String interceptorName = StringUtil.decapitalize((String)annotationType.getSimpleName());
        String suffix = this.getInterceptorSuffix();
        if (namespace != null) {
            return namespace + "." + interceptorName + suffix;
        }
        return interceptorName + suffix;
    }

    public class ExpressionImpl
    implements Expression {
        protected Annotation annotation;

        public ExpressionImpl(Annotation annotation) {
            this.annotation = annotation;
        }

        public Object evaluate(S2Container container, Map context) {
            MethodInterceptor interceptor = (MethodInterceptor)MethodInterceptor.class.cast(container.getComponent((Object)MetaAnnotationAspectDefBuilder.this.getInterceptorName(this.annotation)));
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(interceptor.getClass());
            for (Method method : this.annotation.annotationType().getMethods()) {
                PropertyDesc propertyDesc;
                String propertyName;
                if (method.isBridge() || method.isSynthetic() || "pointcut".equals(propertyName = method.getName()) || !beanDesc.hasPropertyDesc(propertyName) || !(propertyDesc = beanDesc.getPropertyDesc(propertyName)).isWritable()) continue;
                propertyDesc.setValue((Object)interceptor, MethodUtil.invoke((Method)method, (Object)this.annotation, null));
            }
            return interceptor;
        }
    }
}

