/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.seasar.extension.jdbc.AutoInsert;
import org.seasar.extension.jdbc.IdGenerator;
import org.seasar.extension.jdbc.IntoClause;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.ValuesClause;
import org.seasar.extension.jdbc.exception.IdPropertyNotAssignedRuntimeException;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractAutoUpdate;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.NumberConversionUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoInsertImpl<T>
extends AbstractAutoUpdate<T, AutoInsert<T>>
implements AutoInsert<T> {
    protected static final String INSERT_STATEMENT = "insert into ";
    protected static final Long INITIAL_VERSION = 1L;
    protected boolean excludesNull;
    protected final Set<String> includesProperties = CollectionsUtil.newHashSet();
    protected final Set<String> excludesProperties = CollectionsUtil.newHashSet();
    protected final List<PropertyMeta> targetProperties = CollectionsUtil.newArrayList();
    protected final IntoClause intoClause = new IntoClause();
    protected final ValuesClause valuesClause = new ValuesClause();
    protected boolean useGetGeneratedKeys;

    public AutoInsertImpl(JdbcManagerImplementor jdbcManager, T entity) {
        super(jdbcManager, entity);
    }

    @Override
    public AutoInsert<T> excludesNull() {
        this.excludesNull = true;
        return this;
    }

    @Override
    public AutoInsert<T> includes(CharSequence ... propertyNames) {
        this.includesProperties.addAll(Arrays.asList(this.toStringArray(propertyNames)));
        return this;
    }

    @Override
    public AutoInsert<T> excludes(CharSequence ... propertyNames) {
        this.excludesProperties.addAll(Arrays.asList(this.toStringArray(propertyNames)));
        return this;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareTargetProperties();
        this.prepareIntoClause();
        this.prepareValuesClause();
        this.prepareParams();
        this.prepareSql();
    }

    protected void prepareTargetProperties() {
        for (PropertyMeta propertyMeta : this.entityMeta.getAllColumnPropertyMeta()) {
            String propertyName = propertyMeta.getName();
            Field field = propertyMeta.getField();
            Object value = FieldUtil.get((Field)field, (Object)this.entity);
            if (!propertyMeta.getColumnMeta().isInsertable()) continue;
            if (propertyMeta.isId()) {
                if (propertyMeta.hasIdGenerator()) {
                    IdGenerator idGenerator = propertyMeta.getIdGenerator(this.entityMeta, this.jdbcManager.getDialect());
                    this.useGetGeneratedKeys |= idGenerator.useGetGeneratedKeys(this.jdbcManager);
                    if (!idGenerator.isInsertInto(this.jdbcManager)) continue;
                    this.targetProperties.add(propertyMeta);
                    continue;
                }
                if (value != null) {
                    this.targetProperties.add(propertyMeta);
                    continue;
                }
                throw new IdPropertyNotAssignedRuntimeException(this.entityMeta.getName(), propertyMeta.getName());
            }
            if (this.excludesNull && value == null || !this.includesProperties.isEmpty() && !this.includesProperties.contains(propertyName) || this.excludesProperties.contains(propertyName)) continue;
            this.targetProperties.add(propertyMeta);
        }
    }

    protected void prepareIntoClause() {
        for (PropertyMeta propertyMeta : this.targetProperties) {
            this.intoClause.addSql(propertyMeta.getColumnMeta().getName());
        }
    }

    protected void prepareValuesClause() {
        for (PropertyMeta propertyMeta : this.targetProperties) {
            this.valuesClause.addSql();
        }
    }

    protected void prepareParams() {
        for (PropertyMeta propertyMeta : this.targetProperties) {
            Object value;
            if (propertyMeta.isId() && propertyMeta.hasIdGenerator()) {
                value = this.getIdValue(propertyMeta);
            } else {
                value = FieldUtil.get((Field)propertyMeta.getField(), (Object)this.entity);
                if (propertyMeta.isVersion() && (value == null || ((Number)Number.class.cast(value)).longValue() <= 0L)) {
                    value = INITIAL_VERSION;
                    Class fieldClass = ClassUtil.getWrapperClassIfPrimitive(propertyMeta.getPropertyClass());
                    FieldUtil.set((Field)propertyMeta.getField(), (Object)this.entity, (Object)NumberConversionUtil.convertNumber((Class)fieldClass, (Object)value));
                }
            }
            this.addParam(value, propertyMeta);
        }
    }

    protected Object getIdValue(PropertyMeta propertyMeta) {
        IdGenerator idGenerator = propertyMeta.getIdGenerator(this.entityMeta, this.jdbcManager.getDialect());
        return idGenerator.preInsert(this.jdbcManager, this.entity, this);
    }

    @Override
    protected String toSql() {
        String tableName = this.entityMeta.getTableMeta().getFullName();
        StringBuilder buf = new StringBuilder(INSERT_STATEMENT.length() + tableName.length() + this.intoClause.getLength() + this.valuesClause.getLength());
        return new String(buf.append(INSERT_STATEMENT).append(tableName).append(this.intoClause.toSql()).append(this.valuesClause.toSql()));
    }

    @Override
    protected PreparedStatement createPreparedStatement(JdbcContext jdbcContext) {
        if (this.useGetGeneratedKeys) {
            return jdbcContext.getPreparedStatement(this.executedSql, 1);
        }
        return super.createPreparedStatement(jdbcContext);
    }

    @Override
    protected void postExecute(PreparedStatement ps) {
        for (PropertyMeta propertyMeta : this.entityMeta.getIdPropertyMetaList()) {
            if (!propertyMeta.hasIdGenerator()) continue;
            IdGenerator idGenerator = propertyMeta.getIdGenerator(this.entityMeta, this.jdbcManager.getDialect());
            idGenerator.postInsert(this.jdbcManager, this.entity, ps, this);
        }
    }

    @Override
    protected boolean isOptimisticLock() {
        return false;
    }
}

