/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.operation;

import java.util.Collection;
import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.OrderByItem;
import org.seasar.extension.jdbc.Where;
import org.seasar.extension.jdbc.name.PropertyName;
import org.seasar.extension.jdbc.where.CompositeWhere;
import org.seasar.extension.jdbc.where.LikeOperator;
import org.seasar.extension.jdbc.where.MultiValueOperator;
import org.seasar.extension.jdbc.where.SingleValueOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operations {
    public static <PropType, ParamType extends PropType> SingleValueOperator eq(PropertyName<PropType> propertyName, ParamType param) {
        return new SingleValueOperator(ConditionType.EQ, propertyName, param);
    }

    public static <PropType, ParamType extends PropType> SingleValueOperator ne(PropertyName<PropType> propertyName, ParamType param) {
        return new SingleValueOperator(ConditionType.NE, propertyName, param);
    }

    public static <PropType, ParamType extends PropType> SingleValueOperator gt(PropertyName<PropType> propertyName, ParamType param) {
        return new SingleValueOperator(ConditionType.GT, propertyName, param);
    }

    public static <PropType, ParamType extends PropType> SingleValueOperator ge(PropertyName<PropType> propertyName, ParamType param) {
        return new SingleValueOperator(ConditionType.GE, propertyName, param);
    }

    public static <PropType, ParamType extends PropType> SingleValueOperator lt(PropertyName<PropType> propertyName, ParamType param) {
        return new SingleValueOperator(ConditionType.LT, propertyName, param);
    }

    public static <PropType, ParamType extends PropType> SingleValueOperator le(PropertyName<PropType> propertyName, ParamType param) {
        return new SingleValueOperator(ConditionType.LE, propertyName, param);
    }

    public static <PropType, ParamType extends PropType> MultiValueOperator in(PropertyName<PropType> propertyName, ParamType ... params) {
        return new MultiValueOperator(ConditionType.IN, (CharSequence)propertyName, params);
    }

    public static <PropType, ParamType extends PropType> MultiValueOperator in(PropertyName<PropType> propertyName, Collection<? extends ParamType> params) {
        return new MultiValueOperator(ConditionType.IN, propertyName, params);
    }

    public static <PropType, ParamType extends PropType> MultiValueOperator notIn(PropertyName<PropType> propertyName, ParamType ... params) {
        return new MultiValueOperator(ConditionType.NOT_IN, (CharSequence)propertyName, params);
    }

    public static <PropType, ParamType extends PropType> MultiValueOperator notIn(PropertyName<PropType> propertyName, Collection<? extends ParamType> params) {
        return new MultiValueOperator(ConditionType.NOT_IN, propertyName, params);
    }

    public static SingleValueOperator isNull(PropertyName<?> propertyName) {
        return new SingleValueOperator(ConditionType.IS_NULL, propertyName, true);
    }

    public static SingleValueOperator isNull(PropertyName<?> propertyName, Boolean param) {
        return new SingleValueOperator(ConditionType.IS_NULL, propertyName, param);
    }

    public static SingleValueOperator isNotNull(PropertyName<?> propertyName) {
        return new SingleValueOperator(ConditionType.IS_NOT_NULL, propertyName, true);
    }

    public static SingleValueOperator isNotNull(PropertyName<?> propertyName, Boolean param) {
        return new SingleValueOperator(ConditionType.IS_NOT_NULL, propertyName, param);
    }

    public static LikeOperator like(PropertyName<String> propertyName, String param) {
        return new LikeOperator(ConditionType.LIKE, propertyName, param);
    }

    public static LikeOperator like(PropertyName<String> propertyName, String param, String escapeChar) {
        return new LikeOperator(ConditionType.LIKE_ESCAPE, propertyName, (Object)param, escapeChar);
    }

    public static LikeOperator notLike(PropertyName<String> propertyName, String param) {
        return new LikeOperator(ConditionType.NOT_LIKE, propertyName, param);
    }

    public static LikeOperator notLike(PropertyName<String> propertyName, String param, String escapeChar) {
        return new LikeOperator(ConditionType.NOT_LIKE_ESCAPE, propertyName, (Object)param, escapeChar);
    }

    public static LikeOperator starts(PropertyName<String> propertyName, String param) {
        return new LikeOperator(ConditionType.STARTS, propertyName, param);
    }

    public static LikeOperator notStarts(PropertyName<String> propertyName, String param) {
        return new LikeOperator(ConditionType.NOT_STARTS, propertyName, param);
    }

    public static LikeOperator ends(PropertyName<String> propertyName, String param) {
        return new LikeOperator(ConditionType.ENDS, propertyName, param);
    }

    public static LikeOperator notEnds(PropertyName<String> propertyName, String param) {
        return new LikeOperator(ConditionType.NOT_ENDS, propertyName, param);
    }

    public static LikeOperator contains(PropertyName<String> propertyName, String param) {
        return new LikeOperator(ConditionType.CONTAINS, propertyName, param);
    }

    public static LikeOperator notContains(PropertyName<String> propertyName, String param) {
        return new LikeOperator(ConditionType.NOT_CONTAINS, propertyName, param);
    }

    public static CompositeWhere and(Where ... children) {
        return new CompositeWhere("and", children);
    }

    public static CompositeWhere or(Where ... children) {
        return new CompositeWhere("or", children);
    }

    public static OrderByItem asc(CharSequence propertyName) {
        return new OrderByItem(propertyName);
    }

    public static OrderByItem desc(CharSequence propertyName) {
        return new OrderByItem(propertyName, OrderByItem.OrderingSpec.DESC);
    }
}

