/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import org.apache.poi.hwpf.model.HDFType;
import org.apache.poi.hwpf.model.StyleDescription;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.hwpf.sprm.CharacterSprmUncompressor;
import org.apache.poi.hwpf.sprm.ParagraphSprmUncompressor;
import org.apache.poi.hwpf.usermodel.CharacterProperties;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
public final class StyleSheet
implements HDFType {
    public static final int NIL_STYLE = 4095;
    private static final int PAP_TYPE = 1;
    private static final int CHP_TYPE = 2;
    private static final int SEP_TYPE = 4;
    private static final int TAP_TYPE = 5;
    private static final ParagraphProperties NIL_PAP = new ParagraphProperties();
    private static final CharacterProperties NIL_CHP = new CharacterProperties();
    private int _cbStshi;
    private int _cbSTDBaseInFile;
    private int _flags;
    private int _stiMaxWhenSaved;
    private int _istdMaxFixedWhenSaved;
    private int nVerBuiltInNamesWhenSaved;
    private int[] _rgftcStandardChpStsh;
    StyleDescription[] _styleDescriptions;

    public StyleSheet(byte[] tableStream, int offset) {
        int x;
        int startOffset = offset;
        this._cbStshi = LittleEndian.getShort((byte[])tableStream, (int)offset);
        int cstd = LittleEndian.getUShort((byte[])tableStream, (int)(offset += 2));
        this._cbSTDBaseInFile = LittleEndian.getUShort((byte[])tableStream, (int)(offset += 2));
        this._flags = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._stiMaxWhenSaved = LittleEndian.getUShort((byte[])tableStream, (int)(offset += 2));
        this._istdMaxFixedWhenSaved = LittleEndian.getUShort((byte[])tableStream, (int)(offset += 2));
        this.nVerBuiltInNamesWhenSaved = LittleEndian.getUShort((byte[])tableStream, (int)(offset += 2));
        this._rgftcStandardChpStsh = new int[3];
        this._rgftcStandardChpStsh[0] = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._rgftcStandardChpStsh[1] = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._rgftcStandardChpStsh[2] = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        offset += 2;
        offset = startOffset + 2 + this._cbStshi;
        this._styleDescriptions = new StyleDescription[cstd];
        for (x = 0; x < cstd; ++x) {
            short stdSize = LittleEndian.getShort((byte[])tableStream, (int)offset);
            offset += 2;
            if (stdSize > 0) {
                StyleDescription aStyle;
                this._styleDescriptions[x] = aStyle = new StyleDescription(tableStream, this._cbSTDBaseInFile, offset, true);
            }
            offset += stdSize;
        }
        for (x = 0; x < this._styleDescriptions.length; ++x) {
            if (this._styleDescriptions[x] == null) continue;
            this.createPap(x);
            this.createChp(x);
        }
    }

    public void writeTo(HWPFOutputStream out) throws IOException {
        int offset = 0;
        this._cbStshi = 18;
        byte[] buf = new byte[this._cbStshi + 2];
        LittleEndian.putUShort((byte[])buf, (int)offset, (int)((short)this._cbStshi));
        LittleEndian.putUShort((byte[])buf, (int)(offset += 2), (int)((short)this._styleDescriptions.length));
        LittleEndian.putUShort((byte[])buf, (int)(offset += 2), (int)((short)this._cbSTDBaseInFile));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._flags));
        LittleEndian.putUShort((byte[])buf, (int)(offset += 2), (int)((short)this._stiMaxWhenSaved));
        LittleEndian.putUShort((byte[])buf, (int)(offset += 2), (int)((short)this._istdMaxFixedWhenSaved));
        LittleEndian.putUShort((byte[])buf, (int)(offset += 2), (int)((short)this.nVerBuiltInNamesWhenSaved));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._rgftcStandardChpStsh[0]));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._rgftcStandardChpStsh[1]));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._rgftcStandardChpStsh[2]));
        out.write(buf);
        byte[] sizeHolder = new byte[2];
        for (int x = 0; x < this._styleDescriptions.length; ++x) {
            if (this._styleDescriptions[x] != null) {
                byte[] std = this._styleDescriptions[x].toByteArray();
                LittleEndian.putShort((byte[])sizeHolder, (short)((short)(std.length + std.length % 2)));
                out.write(sizeHolder);
                out.write(std);
                if (std.length % 2 != 1) continue;
                out.write(0);
                continue;
            }
            sizeHolder[0] = 0;
            sizeHolder[1] = 0;
            out.write(sizeHolder);
        }
    }

    public boolean equals(Object o) {
        StyleSheet ss = (StyleSheet)o;
        if (ss._cbSTDBaseInFile == this._cbSTDBaseInFile && ss._flags == this._flags && ss._istdMaxFixedWhenSaved == this._istdMaxFixedWhenSaved && ss._stiMaxWhenSaved == this._stiMaxWhenSaved && ss._rgftcStandardChpStsh[0] == this._rgftcStandardChpStsh[0] && ss._rgftcStandardChpStsh[1] == this._rgftcStandardChpStsh[1] && ss._rgftcStandardChpStsh[2] == this._rgftcStandardChpStsh[2] && ss._cbStshi == this._cbStshi && ss.nVerBuiltInNamesWhenSaved == this.nVerBuiltInNamesWhenSaved && ss._styleDescriptions.length == this._styleDescriptions.length) {
            for (int x = 0; x < this._styleDescriptions.length; ++x) {
                if (ss._styleDescriptions[x] == this._styleDescriptions[x] || ss._styleDescriptions[x].equals(this._styleDescriptions[x])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void createPap(int istd) {
        StyleDescription sd = this._styleDescriptions[istd];
        ParagraphProperties pap = sd.getPAP();
        byte[] papx = sd.getPAPX();
        int baseIndex = sd.getBaseStyle();
        if (pap == null && papx != null) {
            ParagraphProperties parentPAP = new ParagraphProperties();
            if (baseIndex != 4095 && (parentPAP = this._styleDescriptions[baseIndex].getPAP()) == null) {
                if (baseIndex == istd) {
                    throw new IllegalStateException("Pap style " + istd + " claimed to have itself as its parent, which isn't allowed");
                }
                this.createPap(baseIndex);
                parentPAP = this._styleDescriptions[baseIndex].getPAP();
            }
            if (parentPAP == null) {
                parentPAP = new ParagraphProperties();
            }
            pap = ParagraphSprmUncompressor.uncompressPAP(parentPAP, papx, 2);
            sd.setPAP(pap);
        }
    }

    private void createChp(int istd) {
        StyleDescription sd = this._styleDescriptions[istd];
        CharacterProperties chp = sd.getCHP();
        byte[] chpx = sd.getCHPX();
        int baseIndex = sd.getBaseStyle();
        if (baseIndex == istd) {
            baseIndex = 4095;
        }
        if (chp == null && chpx != null) {
            CharacterProperties parentCHP = new CharacterProperties();
            if (baseIndex != 4095 && (parentCHP = this._styleDescriptions[baseIndex].getCHP()) == null) {
                this.createChp(baseIndex);
                parentCHP = this._styleDescriptions[baseIndex].getCHP();
            }
            chp = CharacterSprmUncompressor.uncompressCHP(parentCHP, chpx, 0);
            sd.setCHP(chp);
        }
    }

    public int numStyles() {
        return this._styleDescriptions.length;
    }

    public StyleDescription getStyleDescription(int x) {
        return this._styleDescriptions[x];
    }

    public CharacterProperties getCharacterStyle(int x) {
        if (x == 4095) {
            return NIL_CHP;
        }
        if (x >= this._styleDescriptions.length) {
            return NIL_CHP;
        }
        return this._styleDescriptions[x] != null ? this._styleDescriptions[x].getCHP() : NIL_CHP;
    }

    public ParagraphProperties getParagraphStyle(int x) {
        if (x == 4095) {
            return NIL_PAP;
        }
        if (x >= this._styleDescriptions.length) {
            return NIL_PAP;
        }
        if (this._styleDescriptions[x] == null) {
            return NIL_PAP;
        }
        if (this._styleDescriptions[x].getPAP() == null) {
            return NIL_PAP;
        }
        return this._styleDescriptions[x].getPAP();
    }
}

