/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.ExVideoContainer;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogger;

public class ExMCIMovie
extends RecordContainer {
    private byte[] _header = new byte[8];
    private ExVideoContainer exVideo;

    protected ExMCIMovie(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    public ExMCIMovie() {
        this._header[0] = 15;
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        this.exVideo = new ExVideoContainer();
        this._children = new Record[]{this.exVideo};
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof ExVideoContainer) {
            this.exVideo = (ExVideoContainer)this._children[0];
        } else {
            this.logger.log(POILogger.ERROR, (Object)("First child record wasn't a ExVideoContainer, was of type " + this._children[0].getRecordType()));
        }
    }

    public long getRecordType() {
        return RecordTypes.ExMCIMovie.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, out);
    }

    public ExVideoContainer getExVideo() {
        return this.exVideo;
    }
}

