/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.h2.constant.SysProperties;
import org.h2.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profiler
implements Runnable {
    private static Instrumentation instrumentation;
    private static final int MAX_ELEMENTS = 1000;
    public int interval = 2;
    public int depth = 32;
    public boolean paused;
    private String[] ignoreLines = StringUtils.arraySplit("", ',', true);
    private String[] ignorePackages = StringUtils.arraySplit("java,sun,com.sun.,", ',', true);
    private String[] ignoreThreads = StringUtils.arraySplit("java.lang.Object.wait,java.lang.Thread.dumpThreads,java.lang.Thread.getThreads,java.lang.Thread.sleep,java.lang.UNIXProcess.waitForProcessExit,java.net.PlainSocketImpl.accept,java.net.PlainSocketImpl.socketAccept,java.net.SocketInputStream.socketRead,java.net.SocketOutputStream.socketWrite,sun.awt.windows.WToolkit.eventLoop,sun.misc.Unsafe.park,dalvik.system.VMStack.getThreadStackTrace,dalvik.system.NativeStart.run", ',', true);
    private volatile boolean stop;
    private HashMap<String, Integer> counts = new HashMap();
    private HashMap<String, Integer> packages = new HashMap();
    private int minCount = 1;
    private int total;
    private Thread thread;
    private long time;

    public static void premain(String string, Instrumentation instrumentation) {
        Profiler.instrumentation = instrumentation;
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public void startCollecting() {
        this.thread = new Thread((Runnable)this, "Profiler");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stopCollecting() {
        this.stop = true;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    @Override
    public void run() {
        this.time = System.currentTimeMillis();
        while (!this.stop) {
            try {
                this.tick();
            }
            catch (Throwable throwable) {
                // empty catch block
                break;
            }
        }
        this.time = System.currentTimeMillis() - this.time;
    }

    private void tick() {
        if (this.interval > 0) {
            if (this.paused) {
                return;
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] stackTraceElementArray;
            Thread thread = entry.getKey();
            if (thread.getState() != Thread.State.RUNNABLE || (stackTraceElementArray = entry.getValue()) == null || stackTraceElementArray.length == 0 || Profiler.startsWithAny(stackTraceElementArray[0].toString(), this.ignoreThreads)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            boolean bl = false;
            int n = 0;
            for (int i = 0; i < stackTraceElementArray.length && n < this.depth; ++i) {
                String string2 = stackTraceElementArray[i].toString();
                if (string2.equals(string) || Profiler.startsWithAny(string2, this.ignoreLines)) continue;
                string = string2;
                stringBuilder.append("at ").append(string2).append(SysProperties.LINE_SEPARATOR);
                if (!bl && !Profiler.startsWithAny(string2, this.ignorePackages)) {
                    char c;
                    int n2;
                    bl = true;
                    for (n2 = 0; n2 < string2.length() && !Character.isUpperCase(c = string2.charAt(n2)) && c != '('; ++n2) {
                    }
                    if (n2 > 0 && string2.charAt(n2 - 1) == '.') {
                        --n2;
                    }
                    String string3 = string2.substring(0, n2);
                    Profiler.increment(this.packages, string3, 0);
                }
                ++n;
            }
            if (stringBuilder.length() <= 0) continue;
            this.minCount = Profiler.increment(this.counts, stringBuilder.toString().trim(), this.minCount);
            ++this.total;
        }
    }

    private static boolean startsWithAny(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (string2.length() <= 0 || !string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static int increment(HashMap<String, Integer> hashMap, String string, int n) {
        Integer n2 = hashMap.get(string);
        if (n2 == null) {
            hashMap.put(string, 1);
        } else {
            hashMap.put(string, n2 + 1);
        }
        while (hashMap.size() > 1000) {
            Iterator<Map.Entry<String, Integer>> iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> entry = iterator.next();
                if (entry.getValue() > n) continue;
                iterator.remove();
            }
            if (hashMap.size() <= 1000) continue;
            ++n;
        }
        return n;
    }

    public String getTop(int n) {
        this.stopCollecting();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Profiler: top ").append(n).append(" stack trace(s) of ").append(this.time).append(" ms [build-").append(167).append("]:").append(SysProperties.LINE_SEPARATOR);
        if (this.counts.size() == 0) {
            stringBuilder.append("(none)").append(SysProperties.LINE_SEPARATOR);
        }
        Profiler.appendTop(stringBuilder, this.counts, n, this.total, false);
        stringBuilder.append("packages:").append(SysProperties.LINE_SEPARATOR);
        Profiler.appendTop(stringBuilder, this.packages, n, this.total, true);
        stringBuilder.append('.');
        return stringBuilder.toString();
    }

    private static void appendTop(StringBuilder stringBuilder, HashMap<String, Integer> hashMap, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = 0;
            Map.Entry<String, Integer> entry = null;
            for (Map.Entry<String, Integer> entry2 : hashMap.entrySet()) {
                if (entry2.getValue() <= n5) continue;
                entry = entry2;
                n5 = entry2.getValue();
            }
            if (entry == null) break;
            hashMap.remove(entry.getKey());
            if (++n3 >= n) {
                if (entry.getValue() < n4) break;
                n4 = entry.getValue();
            }
            int n6 = entry.getValue();
            int n7 = 100 * n6 / Math.max(n2, 1);
            if (bl) {
                if (n7 <= 1) continue;
                stringBuilder.append(n7).append("%: ").append(entry.getKey()).append(SysProperties.LINE_SEPARATOR);
                continue;
            }
            stringBuilder.append(n6).append('/').append(n2).append(" (").append(n7).append("%):").append(SysProperties.LINE_SEPARATOR).append(entry.getKey()).append(SysProperties.LINE_SEPARATOR);
        }
    }
}

