/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.validator;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.FieldChecks;
import org.apache.struts.validator.Resources;
import org.seasar.struts.validator.S2GenericValidator;

public class S2FieldChecks
extends FieldChecks {
    private static final long serialVersionUID = 1L;

    public static boolean validateMaxByteLength(Object bean, ValidatorAction validatorAction, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = S2FieldChecks.getValueAsString(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int max = Integer.parseInt(field.getVarValue("maxbytelength"));
                String charset = field.getVarValue("charset");
                if (!S2GenericValidator.maxByteLength(value, max, charset)) {
                    S2FieldChecks.addError(errors, field, validator, validatorAction, request);
                    return false;
                }
            }
            catch (Exception e) {
                S2FieldChecks.addError(errors, field, validator, validatorAction, request);
                return false;
            }
        }
        return true;
    }

    public static boolean validateMinByteLength(Object bean, ValidatorAction validatorAction, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = S2FieldChecks.getValueAsString(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int min = Integer.parseInt(field.getVarValue("minbytelength"));
                String charset = field.getVarValue("charset");
                if (!S2GenericValidator.minByteLength(value, min, charset)) {
                    S2FieldChecks.addError(errors, field, validator, validatorAction, request);
                    return false;
                }
            }
            catch (Exception e) {
                S2FieldChecks.addError(errors, field, validator, validatorAction, request);
                return false;
            }
        }
        return true;
    }

    public static boolean validateLongRange(Object bean, ValidatorAction validatorAction, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = S2FieldChecks.getValueAsString(bean, field);
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                long longValue = Long.parseLong(value);
                long min = Long.parseLong(field.getVarValue("min"));
                long max = Long.parseLong(field.getVarValue("max"));
                if (!GenericValidator.isInRange((long)longValue, (long)min, (long)max)) {
                    S2FieldChecks.addError(errors, field, validator, validatorAction, request);
                    return false;
                }
            }
            catch (Exception e) {
                S2FieldChecks.addError(errors, field, validator, validatorAction, request);
                return false;
            }
        }
        return true;
    }

    protected static String getValueAsString(Object bean, Field field) {
        if (S2FieldChecks.isString((Object)bean)) {
            return (String)bean;
        }
        return ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
    }

    protected static void addError(ActionMessages errors, Field field, Validator validator, ValidatorAction validatorAction, HttpServletRequest request) {
        errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)validatorAction, (Field)field));
    }
}

