/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uima.processor;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrUIMAConfiguration {
    private String[] fieldsToAnalyze;
    private boolean fieldsMerging;
    private Map<String, Map<String, MapField>> typesFeaturesFieldsMapping;
    private String aePath;
    private Map<String, Object> runtimeParameters;
    private boolean ignoreErrors;
    private String logField;

    public SolrUIMAConfiguration(String aePath, String[] fieldsToAnalyze, boolean fieldsMerging, Map<String, Map<String, MapField>> typesFeaturesFieldsMapping, Map<String, Object> runtimeParameters, boolean ignoreErrors, String logField) {
        this.aePath = aePath;
        this.fieldsToAnalyze = fieldsToAnalyze;
        this.fieldsMerging = fieldsMerging;
        this.runtimeParameters = runtimeParameters;
        this.typesFeaturesFieldsMapping = typesFeaturesFieldsMapping;
        this.ignoreErrors = ignoreErrors;
        this.logField = logField;
    }

    public String[] getFieldsToAnalyze() {
        return this.fieldsToAnalyze;
    }

    public boolean isFieldsMerging() {
        return this.fieldsMerging;
    }

    public Map<String, Map<String, MapField>> getTypesFeaturesFieldsMapping() {
        return this.typesFeaturesFieldsMapping;
    }

    public String getAePath() {
        return this.aePath;
    }

    public Map<String, Object> getRuntimeParameters() {
        return this.runtimeParameters;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public String getLogField() {
        return this.logField;
    }

    static final class MapField {
        private String fieldName;
        private String fieldNameFeature;
        private boolean prefix;

        MapField(String fieldName, String fieldNameFeature) {
            this.fieldName = fieldName;
            this.fieldNameFeature = fieldNameFeature;
            if (fieldNameFeature != null) {
                if (fieldName.startsWith("*")) {
                    this.prefix = false;
                    this.fieldName = fieldName.substring(1);
                } else if (fieldName.endsWith("*")) {
                    this.prefix = true;
                    this.fieldName = fieldName.substring(0, fieldName.length() - 1);
                } else {
                    throw new RuntimeException("static field name cannot be used for dynamicField");
                }
            }
        }

        String getFieldNameFeature() {
            return this.fieldNameFeature;
        }

        String getFieldName(String featureValue) {
            if (this.fieldNameFeature != null) {
                return this.prefix ? this.fieldName + featureValue : featureValue + this.fieldName;
            }
            return this.fieldName;
        }
    }
}

