/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu.segmentation;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UTF16;

final class ScriptIterator {
    private char[] text;
    private int start;
    private int limit;
    private int index;
    private int scriptStart;
    private int scriptLimit;
    private int scriptCode;
    private static final int[] basicLatin = new int[128];

    ScriptIterator() {
    }

    int getScriptStart() {
        return this.scriptStart;
    }

    int getScriptLimit() {
        return this.scriptLimit;
    }

    int getScriptCode() {
        return this.scriptCode;
    }

    boolean next() {
        int ch;
        int sc;
        if (this.scriptLimit >= this.limit) {
            return false;
        }
        this.scriptCode = 0;
        this.scriptStart = this.scriptLimit;
        while (this.index < this.limit && (ScriptIterator.isSameScript(this.scriptCode, sc = ScriptIterator.getScript(ch = UTF16.charAt((char[])this.text, (int)this.start, (int)this.limit, (int)(this.index - this.start)))) || UCharacter.getType((int)ch) == 6)) {
            this.index += UTF16.getCharCount((int)ch);
            if (this.scriptCode > 1 || sc <= 1) continue;
            this.scriptCode = sc;
        }
        this.scriptLimit = this.index;
        return true;
    }

    private static boolean isSameScript(int scriptOne, int scriptTwo) {
        return scriptOne <= 1 || scriptTwo <= 1 || scriptOne == scriptTwo;
    }

    void setText(char[] text, int start, int length) {
        this.text = text;
        this.start = start;
        this.index = start;
        this.limit = start + length;
        this.scriptStart = start;
        this.scriptLimit = start;
        this.scriptCode = -1;
    }

    private static int getScript(int codepoint) {
        if (0 <= codepoint && codepoint < basicLatin.length) {
            return basicLatin[codepoint];
        }
        return UScript.getScript((int)codepoint);
    }

    static {
        for (int i = 0; i < basicLatin.length; ++i) {
            ScriptIterator.basicLatin[i] = UScript.getScript((int)i);
        }
    }
}

