/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableLongFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.util.NumberUtils;

public class SortableLongField
extends PrimitiveFieldType {
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        return new SortableLongFieldSource(field.name);
    }

    public String toInternal(String val) {
        return NumberUtils.long2sortableStr(val);
    }

    public String indexedToReadable(String indexedForm) {
        return NumberUtils.SortableStr2long(indexedForm);
    }

    public String toExternal(Fieldable f) {
        return this.indexedToReadable(f.stringValue());
    }

    public Long toObject(Fieldable f) {
        return NumberUtils.SortableStr2long(f.stringValue(), 0, 5);
    }

    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        String sval = f.stringValue();
        xmlWriter.writeLong(name, NumberUtils.SortableStr2long(sval, 0, sval.length()));
    }

    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        String sval = f.stringValue();
        writer.writeLong(name, NumberUtils.SortableStr2long(sval, 0, sval.length()));
    }
}

