/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.solr.request.TermIndex;

class NumberedTermEnum
extends TermEnum {
    protected final IndexReader reader;
    protected final TermIndex tindex;
    protected TermEnum tenum;
    protected int pos = -1;
    protected Term t;
    protected TermDocs termDocs;

    NumberedTermEnum(IndexReader reader, TermIndex tindex) throws IOException {
        this.reader = reader;
        this.tindex = tindex;
    }

    NumberedTermEnum(IndexReader reader, TermIndex tindex, String termValue, int pos) throws IOException {
        this.reader = reader;
        this.tindex = tindex;
        this.pos = pos;
        this.tenum = reader.terms(tindex.createTerm(termValue));
        this.setTerm();
    }

    public TermDocs getTermDocs() throws IOException {
        if (this.termDocs == null) {
            this.termDocs = this.reader.termDocs(this.t);
        } else {
            this.termDocs.seek(this.t);
        }
        return this.termDocs;
    }

    protected boolean setTerm() {
        this.t = this.tenum.term();
        if (this.t == null || this.t.field() != this.tindex.fterm.field() || this.tindex.prefix != null && !this.t.text().startsWith(this.tindex.prefix, 0)) {
            this.t = null;
            return false;
        }
        return true;
    }

    public boolean next() throws IOException {
        ++this.pos;
        boolean b = this.tenum.next();
        if (!b) {
            this.t = null;
            return false;
        }
        return this.setTerm();
    }

    public Term term() {
        return this.t;
    }

    public int docFreq() {
        return this.tenum.docFreq();
    }

    public void close() throws IOException {
        if (this.tenum != null) {
            this.tenum.close();
        }
    }

    public boolean skipTo(String target) throws IOException {
        return this.skipTo(this.tindex.fterm.createTerm(target));
    }

    public boolean skipTo(Term target) throws IOException {
        if (this.t != null && this.t.equals((Object)target)) {
            return true;
        }
        int startIdx = Arrays.binarySearch(this.tindex.index, target.text());
        if (startIdx >= 0) {
            if (this.tenum != null) {
                this.tenum.close();
            }
            this.tenum = this.reader.terms(target);
            this.pos = startIdx << 7;
            return this.setTerm();
        }
        if ((startIdx = -startIdx - 1) == 0) {
            if (this.tenum != null) {
                this.tenum.close();
            }
            this.tenum = this.reader.terms(target);
            this.pos = 0;
            return this.setTerm();
        }
        if (this.pos >> 7 != --startIdx || this.t == null || this.t.text().compareTo(target.text()) > 0) {
            if (this.tenum != null) {
                this.tenum.close();
            }
            this.tenum = this.reader.terms(target.createTerm(this.tindex.index[startIdx]));
            this.pos = startIdx << 7;
            this.setTerm();
        }
        while (this.t != null && this.t.text().compareTo(target.text()) < 0) {
            this.next();
        }
        return this.t != null;
    }

    public boolean skipTo(int termNumber) throws IOException {
        int delta = termNumber - this.pos;
        if (delta < 0 || delta > 128 || this.tenum == null) {
            int idx = termNumber >>> 7;
            String base = this.tindex.index[idx];
            this.pos = idx << 7;
            delta = termNumber - this.pos;
            if (this.tenum != null) {
                this.tenum.close();
            }
            this.tenum = this.reader.terms(this.tindex.createTerm(base));
        }
        while (--delta >= 0) {
            boolean b = this.tenum.next();
            if (!b) {
                this.t = null;
                return false;
            }
            ++this.pos;
        }
        return this.setTerm();
    }

    public int getTermNumber() {
        return this.pos;
    }
}

