/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class RefCntRamDirectory
extends RAMDirectory {
    private final AtomicInteger refCount = new AtomicInteger();

    public RefCntRamDirectory() {
        this.refCount.set(1);
    }

    public RefCntRamDirectory(Directory dir) throws IOException {
        this();
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        for (String file : dir.listAll()) {
            if (!filter.accept(null, file)) continue;
            dir.copy((Directory)this, file, file);
        }
    }

    public void incRef() {
        this.ensureOpen();
        this.refCount.incrementAndGet();
    }

    public void decRef() {
        this.ensureOpen();
        if (this.refCount.getAndDecrement() == 1) {
            super.close();
        }
    }

    public final synchronized void close() {
        this.decRef();
    }

    public boolean isOpen() {
        return this.isOpen;
    }
}

