/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.VariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateString {
    private List<String> variables = new ArrayList<String>();
    private List<String> pcs = new ArrayList<String>();
    private Map<String, TemplateString> cache;
    static final Pattern WORD_PATTERN = Pattern.compile("(\\$\\{.*?\\})");

    public TemplateString() {
        this.cache = new ConcurrentHashMap<String, TemplateString>();
    }

    private TemplateString(String s) {
        Matcher m = WORD_PATTERN.matcher(s);
        int idx = 0;
        while (m.find()) {
            String aparam = s.substring(m.start() + 2, m.end() - 1);
            this.variables.add(aparam);
            this.pcs.add(s.substring(idx, m.start()));
            idx = m.end();
        }
        this.pcs.add(s.substring(idx));
    }

    public String replaceTokens(String string, VariableResolver resolver) {
        if (string == null) {
            return null;
        }
        TemplateString ts = this.cache.get(string);
        if (ts == null) {
            ts = new TemplateString(string);
            this.cache.put(string, ts);
        }
        return ts.fillTokens(resolver);
    }

    private String fillTokens(VariableResolver resolver) {
        String[] s = new String[this.variables.size()];
        for (int i = 0; i < this.variables.size(); ++i) {
            Object val = resolver.resolve(this.variables.get(i));
            s[i] = val == null ? "" : this.getObjectAsString(val);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.pcs.size(); ++i) {
            sb.append(this.pcs.get(i));
            if (i >= s.length) continue;
            sb.append(s[i]);
        }
        return sb.toString();
    }

    private String getObjectAsString(Object val) {
        if (val instanceof Date) {
            Date d = (Date)val;
            return DataImporter.DATE_TIME_FORMAT.get().format(d);
        }
        return val.toString();
    }

    public static List<String> getVariables(String s) {
        return new TemplateString((String)s).variables;
    }
}

