/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.extension.jdbc.util.BindVariableUtil;
import org.seasar.framework.util.StringConversionUtil;

public class CharacterType
extends AbstractValueType {
    public CharacterType() {
        super(1);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return this.toCharacter(resultSet.getString(index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return this.toCharacter(resultSet.getString(columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.toCharacter(cs.getString(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.toCharacter(cs.getString(parameterName));
    }

    private Character toCharacter(String value) {
        if (value == null) {
            return null;
        }
        char[] chars = value.toCharArray();
        if (chars.length == 1) {
            return new Character(chars[0]);
        }
        if (chars.length == 0) {
            return null;
        }
        throw new IllegalStateException("length of String should be 1. actual is [" + value + "]");
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setString(index, StringConversionUtil.toString((Object)value));
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setString(parameterName, StringConversionUtil.toString((Object)value));
        }
    }

    public String toText(Object value) {
        if (value == null) {
            return BindVariableUtil.nullText();
        }
        String var = StringConversionUtil.toString((Object)value);
        return BindVariableUtil.toText(var);
    }
}

