/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.util;

import org.seasar.extension.dxo.util.SimpleExpression;
import org.seasar.extension.dxo.util.SimpleExpressionParseException;

public class SimpleExpressionParser {
    protected String source;
    protected int length;
    protected int index;
    protected SimpleExpression expression;

    public static SimpleExpression parse(String source) {
        SimpleExpressionParser parser = new SimpleExpressionParser(source);
        return parser.conversionRuleList();
    }

    protected SimpleExpressionParser(String source) {
        this.source = source;
        this.length = source.length();
        this.expression = new SimpleExpression();
    }

    protected SimpleExpression conversionRuleList() {
        try {
            this.conversionRule();
            while (this.comma()) {
                this.conversionRule();
            }
            this.eof();
            return this.expression;
        }
        catch (SimpleExpressionParseException e) {
            return null;
        }
    }

    protected void conversionRule() {
        this.destProperty();
        this.colon();
        if (!this.nullLiteral()) {
            this.sourcePropertyList();
        }
    }

    protected boolean comma() {
        return this.nextChar(',');
    }

    protected void eof() {
        this.skipWhiteSpace();
        if (this.index < this.length) {
            throw new SimpleExpressionParseException();
        }
    }

    protected void destProperty() {
        String name = this.nextIdentifier();
        this.expression.addDestProperty(name);
    }

    protected void colon() {
        if (!this.nextChar(':')) {
            throw new SimpleExpressionParseException();
        }
    }

    protected void sourcePropertyList() {
        this.sourceProperty();
        while (this.period()) {
            this.sourceProperty();
        }
    }

    protected void sourceProperty() {
        String value = this.nextIdentifier();
        this.expression.addSourceProperty(value);
    }

    protected boolean nullLiteral() {
        int savedIndex = this.index;
        String value = this.nextIdentifier();
        if ("null".equals(value)) {
            this.expression.addSourceProperty(null);
            return true;
        }
        this.index = savedIndex;
        return false;
    }

    protected boolean period() {
        return this.nextChar('.');
    }

    protected void skipWhiteSpace() {
        while (this.index < this.length) {
            if (!Character.isWhitespace(this.source.charAt(this.index))) {
                return;
            }
            ++this.index;
        }
    }

    protected boolean nextChar(char expected) {
        this.skipWhiteSpace();
        if (this.index >= this.length) {
            return false;
        }
        if (this.source.charAt(this.index) == expected) {
            ++this.index;
            return true;
        }
        return false;
    }

    protected String nextIdentifier() {
        this.skipWhiteSpace();
        if (this.index >= this.length || !Character.isJavaIdentifierStart(this.source.charAt(this.index))) {
            throw new SimpleExpressionParseException();
        }
        int beginIndex = this.index;
        while (this.index < this.length && Character.isJavaIdentifierPart(this.source.charAt(this.index))) {
            ++this.index;
        }
        int endIndex = this.index;
        return this.source.substring(beginIndex, endIndex);
    }
}

