/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;

public class CharArrayConverter
extends AbstractConverter {
    public Class[] getSourceClasses() {
        return new Class[]{Object.class};
    }

    public Class getDestClass() {
        return [C.class;
    }

    public Object convert(Object source, Class destClass, ConversionContext context) {
        if (source == null) {
            return null;
        }
        if (source instanceof char[]) {
            if (this.shallowCopy) {
                return source;
            }
            char[] sourceArray = (char[])source;
            char[] dest = new char[sourceArray.length];
            System.arraycopy(sourceArray, 0, dest, 0, sourceArray.length);
            return sourceArray;
        }
        if (source instanceof String) {
            return ((String)source).toCharArray();
        }
        return source.toString().toCharArray();
    }
}

