/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.Converter;
import org.seasar.extension.dxo.converter.ParameterizedClassConverter;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;
import org.seasar.framework.beans.ParameterizedClassDesc;

public abstract class AbstractParameterizedCollectionConverter
extends AbstractConverter
implements ParameterizedClassConverter {
    public void convert(Object source, Object dest, ConversionContext context) {
        Collection destCollection = (Collection)dest;
        if (source.getClass().isArray()) {
            int length = Array.getLength(source);
            for (int i = 0; i < length; ++i) {
                destCollection.add(Array.get(source, i));
            }
        } else if (source instanceof Collection) {
            destCollection.addAll((Collection)source);
        } else {
            destCollection.add(source);
        }
    }

    public void convert(Object source, Object dest, ParameterizedClassDesc parameterizedClassDesc, ConversionContext context) {
        Collection destCollection = (Collection)dest;
        Class destElementClass = this.getElementClass(parameterizedClassDesc);
        if (destElementClass == null) {
            this.convert(source, dest, context);
        } else if (source.getClass().isArray()) {
            this.convertFromArray(source, destCollection, destElementClass, context);
        } else if (source instanceof Collection) {
            this.convertFromCollection((Collection)source, destCollection, destElementClass, context);
        } else if (this.shallowCopy && destElementClass.isAssignableFrom(source.getClass())) {
            destCollection.add(source);
        } else {
            Converter converter = context.getConverterFactory().getConverter(source.getClass(), destElementClass);
            destCollection.add(converter.convert(source, destElementClass, context));
        }
    }

    protected Class getElementClass(ParameterizedClassDesc parameterizedClassDesc) {
        if (parameterizedClassDesc == null || !parameterizedClassDesc.isParameterizedClass()) {
            return null;
        }
        ParameterizedClassDesc[] arguments = parameterizedClassDesc.getArguments();
        if (arguments.length != 1) {
            return null;
        }
        return arguments[0].getRawClass();
    }

    protected void convertFromArray(Object source, Collection dest, Class destElementClass, ConversionContext context) {
        if (destElementClass == null) {
            this.convert(source, dest, context);
            return;
        }
        Class<?> sourceElementClass = source.getClass().getComponentType();
        Converter converter = context.getConverterFactory().getConverter(sourceElementClass, destElementClass);
        int length = Array.getLength(source);
        for (int i = 0; i < length; ++i) {
            Object sourceElement = Array.get(source, i);
            if (sourceElement == null) {
                dest.add(null);
                continue;
            }
            if (this.shallowCopy && destElementClass.isAssignableFrom(sourceElement.getClass())) {
                dest.add(sourceElement);
                continue;
            }
            dest.add(converter.convert(sourceElement, destElementClass, context));
        }
    }

    protected void convertFromCollection(Collection source, Collection dest, Class destElementClass, ConversionContext context) {
        if (destElementClass == null) {
            this.convert((Object)source, dest, context);
            return;
        }
        Iterator it = source.iterator();
        while (it.hasNext()) {
            Object sourceElement = it.next();
            if (sourceElement == null) {
                dest.add(null);
                continue;
            }
            if (this.shallowCopy && destElementClass.isAssignableFrom(sourceElement.getClass())) {
                dest.add(sourceElement);
                continue;
            }
            Converter converter = context.getConverterFactory().getConverter(sourceElement.getClass(), destElementClass);
            dest.add(converter.convert(sourceElement, destElementClass, context));
        }
    }
}

