/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute.constraint;

import java.lang.annotation.Annotation;
import org.carrot2.util.attribute.constraint.Constraint;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;

@Root(name="implementing-classes")
class ImplementingClassesConstraint
extends Constraint {
    @ElementArray
    private Class<?>[] classes;
    @Attribute
    private boolean strict;

    ImplementingClassesConstraint() {
    }

    protected boolean isMet(Object value) {
        Class<?> target;
        if (value == null) {
            return true;
        }
        if (value instanceof Class) {
            target = (Class<?>)value;
            if (target.isInterface()) {
                return false;
            }
        } else {
            target = value.getClass();
        }
        for (Class<?> clazz : this.classes) {
            if (!clazz.isAssignableFrom(target)) continue;
            return true;
        }
        return !this.strict;
    }

    protected void populateCustom(Annotation annotation) {
        ImplementingClasses implementingClasses = (ImplementingClasses)annotation;
        this.classes = implementingClasses.classes();
        this.strict = implementingClasses.strict();
    }
}

