/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.pubmed;

import org.carrot2.core.Document;
import org.carrot2.core.ProcessingException;
import org.carrot2.source.SearchEngineResponse;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class PubMedFetchHandler
implements ContentHandler {
    private SearchEngineResponse response = new SearchEngineResponse();
    private StringBuffer text = new StringBuffer();
    private boolean inArticleTitle;
    private boolean inArticleAbstract;
    private boolean inArticleId;
    private String title;
    private String snippet;
    private String id;

    public SearchEngineResponse getResponse() {
        return this.response;
    }

    public void startDocument() throws SAXException {
        this.text.setLength(0);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("PubmedArticle".equals(localName)) {
            this.id = null;
            this.snippet = null;
            this.title = null;
        }
        this.inArticleTitle = "ArticleTitle".equals(localName);
        this.inArticleAbstract = "AbstractText".equals(localName);
        this.inArticleId = "PMID".equals(localName);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.inArticleTitle) {
            this.title = this.text.toString();
            this.inArticleTitle = false;
        } else if (this.inArticleAbstract) {
            this.snippet = this.text.toString();
            this.inArticleAbstract = false;
        } else if (this.inArticleId) {
            this.id = this.text.toString();
            this.inArticleId = false;
        } else if ("PubmedArticle".equals(localName)) {
            try {
                this.response.results.add(new Document(this.title, this.snippet, "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&id=" + this.id + "&retmode=html&rettype=abstract"));
            }
            catch (ProcessingException e) {
                throw new SAXException("Problem with the serach results consumer", e);
            }
        }
        this.text.setLength(0);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
    }

    public void endDocument() throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

