/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.boss;

import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.Document;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.boss.BossImageSearchService;
import org.carrot2.source.boss.BossNewsSearchService;
import org.carrot2.source.boss.BossSearchService;
import org.carrot2.source.boss.BossWebSearchService;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable(prefix="BossDocumentSource")
public final class BossDocumentSource
extends MultipageSearchEngine {
    static final Logger logger = LoggerFactory.getLogger(BossDocumentSource.class);
    private static final int MAX_CONCURRENT_THREADS = 5;
    @Input
    @Processing
    @Attribute
    public boolean keepHighlights = false;
    @Init
    @Input
    @Attribute
    @ImplementingClasses(classes={BossWebSearchService.class, BossNewsSearchService.class, BossImageSearchService.class})
    public BossSearchService service = new BossWebSearchService();
    private static final Pattern WBR_PATTERN = Pattern.compile("<wbr>");

    @Override
    public void process() throws ProcessingException {
        super.process(this.service.metadata, this.getSharedExecutor(5, this.getClass()));
    }

    @Override
    protected final Callable<SearchEngineResponse> createFetcher(final MultipageSearchEngine.SearchRange bucket) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(){

            public SearchEngineResponse search() throws Exception {
                return BossDocumentSource.this.service.query(BossDocumentSource.this.query, bucket.start, bucket.results);
            }
        };
    }

    @Override
    protected void afterFetch(SearchEngineResponse response) {
        String[] fields = new String[]{"title", "snippet"};
        BossDocumentSource.clean(response, this.keepHighlights, fields);
        for (Document document : response.results) {
            for (String field : fields) {
                String originalField = (String)document.getField(field);
                if (!StringUtils.isNotBlank((String)originalField)) continue;
                Matcher matcher = WBR_PATTERN.matcher(originalField);
                document.setField(field, matcher.replaceAll(""));
            }
        }
    }
}

