/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source;

import org.carrot2.core.ProcessingException;
import org.carrot2.source.SearchEngineBase;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.attribute.Bindable;

@Bindable
public abstract class SimpleSearchEngine
extends SearchEngineBase {
    protected abstract SearchEngineResponse fetchSearchResponse() throws Exception;

    public void process() throws ProcessingException {
        try {
            SearchEngineResponse response = this.fetchSearchResponse();
            this.documents = response.results;
            this.resultsTotal = response.getResultsTotal();
            this.compressed = false;
            String compression = (String)response.metadata.get("compression");
            if (compression != null && "gzip".contains(compression)) {
                this.compressed = true;
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAs(ProcessingException.class, e);
        }
    }
}

